﻿using Newtonsoft.Json;
using Resonance.Core.Services.CustomConfigService;
using System;
using System.Collections.Generic;
using System.Globalization;

namespace Resonance.Core.Services.LocalizationService
{
	public class LocalizationService : ILocalizationService
	{
		private ICustomConfigService _customConfigService;
		private string _environment;    // "Development", "Staging", "Production"
        private static string _system = "localization";
        private string _locale;	// ex. "en-us"
		private Dictionary<string, string> _localizationData;

		public LocalizationService(string locale, string environment)
		{
			_locale = locale;
			_environment = environment;

			_customConfigService = new CustomConfigService.CustomConfigService(_environment);

			DownloadLocalization();
		}

		// Download the current localization dictionary from S3
		public void DownloadLocalization()
		{
			_localizationData = new Dictionary<string, string>(StringComparer.InvariantCultureIgnoreCase);

			string json = _customConfigService.GetConfig(_system, _locale, true);
			dynamic values = JsonConvert.DeserializeObject(json);

			foreach (var value in values)
			{
				string keyName = value.Name;

				if (!string.IsNullOrEmpty(keyName))
				{
                    string strValue = value.Value;
					_localizationData.Add(keyName, strValue);
				}
			}
		}

		// Upload the current localization dictionary back to S3
		public void UploadLocalization()
		{
			string json = JsonConvert.SerializeObject(_localizationData);
			_customConfigService.UploadConfigData(_system, _locale, json);
		}

		// Add or update localization string
		public void AssignString(string keyName, string value)
		{
			_localizationData[keyName] = value;
		}

		// Return a localization string
		public string GetString(string keyName)
		{
			return _localizationData.ContainsKey(keyName) ? _localizationData[keyName] : "";
		}

		// Returns a copy of the current localization dictionary (uses a copy to avoid providing direct access)
		public Dictionary<string, string> GetAllStrings()
		{
			Dictionary<string, string> localizationCopy = new Dictionary<string, string>();
			foreach (var pair in _localizationData)
			{
				localizationCopy.Add(pair.Key, pair.Value);
			}
			return localizationCopy;
		}
	}
}
