﻿using System;
using System.Collections.Generic;
using Resonance.Core.Helpers.StatsDHelpers;
using Microsoft.AspNetCore.Diagnostics;
using Microsoft.AspNetCore.Mvc;
using Resonance.Core.ViewModels;
using System.Diagnostics;
using Resonance.Core.Exceptions;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models.ApiModels;
using Resonance.Core;
using Resonance.Core.Helpers.AwsHelpers;
using Amazon.CloudWatch;

namespace Resonance.Api.MicroServices.Controllers
{
    [Route("error")]
    public class ErrorController : Controller
    {
        public ErrorController()
        {
        }

        [HttpGet("force-test-exception/{0}")]
        public JsonResult ForceTestException(int exceptionCode)
        {
            try
            {
                CloudwatchHelper.EnqueueMetricRequest($"force_exception_{exceptionCode}", 1, Request.HttpContext, StandardUnit.Count);
                throw new TestException(Request.HttpContext, exceptionCode);
            }
            catch (Exception ex)
            {
                Log.Error(ex, context: HttpContext);
                throw;
            }
        }

        [HttpGet("{0}")]
        public JsonResult ErrorHandler()
        {
            var response = new ApiResponse<ErrorViewModel>()
            {
                RequestStartTime = DateTime.UtcNow,
                WorkerIdentifier = ConstantsWorker.WorkerIdentifier
            };

            var feature = Request?.HttpContext?.Features?.Get<IStatusCodeReExecuteFeature>();
            var path = feature?.OriginalPath;
            int statusCode = 500;
            int.TryParse(HttpContext.Request.Path.ToString().Replace("/error/", ""), out statusCode);
            HttpContext.Response.StatusCode = statusCode;
            var model = new ErrorViewModel()
            {
                StatusCode = statusCode,
                Path = (HttpContext.Response.Headers["original-path"].ToString()) ?? path,
                ErrorMessage = (HttpContext.Response.Headers["error-message"].ToString()),
                RequestId = Activity.Current?.Id ?? HttpContext.TraceIdentifier
            };
            CloudwatchHelper.EnqueueMetricRequest($"route_error_{statusCode}", 1, Request.HttpContext, StandardUnit.Count);
            StatsDHelper.Counter(measurement: "route_error", measurementType: "route_error", val: 1, location: "route_error", additionalTags: $",error_type={HttpContext.Response.StatusCode},original_path={model.Path}");
            response.ResponseData = model;


            return new JsonResult(response);
        }
    }
}