﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Amazon.CloudWatch;
using Microsoft.AspNetCore.Mvc;
using Resonance.Core;
using Resonance.Core.Helpers.AwsHelpers;
using Resonance.Core.Models.ApiModels;
using Resonance.Core.Models.ApiModels.HealthModels;

namespace Resonance.Api.Microservices.Controllers
{
    public class HealthController : Controller
    {
        [HttpGet("heartbeat")]
        public JsonResult GetHeartbeat()
        {
            CloudwatchHelper.EnqueueMetricRequest("heartbeat_endpoint", 1, HttpContext, StandardUnit.Count);
            return new JsonResult(new ApiResponse<HeartbeatModel>()
            {
                RequestStartTime = DateTime.UtcNow,
                RequestEndTime = DateTime.UtcNow,
                Success = true,
                WorkerIdentifier = ConstantsWorker.WorkerIdentifier,
                ResponseData = new HeartbeatModel() { Timestamp = DateTime.UtcNow }
            });
        }

        [HttpGet("ping")]
        public JsonResult GetPing()
        {
            CloudwatchHelper.EnqueueMetricRequest("ping_endpoint", 1, HttpContext, StandardUnit.Count);
            return new JsonResult(new ApiResponse<PongModel>()
            {
                RequestStartTime = DateTime.UtcNow,
                RequestEndTime = DateTime.UtcNow,
                Success = true,
                WorkerIdentifier = ConstantsWorker.WorkerIdentifier,
                ResponseData = new PongModel() { Status = "pong" }
            });
        }

        [HttpGet("getmyip")]
        public JsonResult GetMyIP()
        {
            CloudwatchHelper.EnqueueMetricRequest("get_ip_endpoint", 1, HttpContext, StandardUnit.Count);
            return new JsonResult(new ApiResponse<IPModel>()
            {
                RequestStartTime = DateTime.UtcNow,
                RequestEndTime = DateTime.UtcNow,
                Success = true,
                WorkerIdentifier = ConstantsWorker.WorkerIdentifier,
                ResponseData = new IPModel() { IP = HttpContext.Connection.RemoteIpAddress }
            });
        }

        [HttpGet("version")]
        public JsonResult Version()
        {
            CloudwatchHelper.EnqueueMetricRequest("get_version_endpoint", 1, HttpContext, StandardUnit.Count);
            return new JsonResult(new ApiResponse<VersionModel>()
            {
                RequestStartTime = DateTime.UtcNow,
                RequestEndTime = DateTime.UtcNow,
                Success = true,
                WorkerIdentifier = ConstantsWorker.WorkerIdentifier,
                ResponseData = new VersionModel() { Version = Constants.ApplicationVersion }
            });
        }
        
        [HttpGet("verify-api-token")]
        public JsonResult VerifyApiToken()
        {
            CloudwatchHelper.EnqueueMetricRequest("verify_api_token_endpoint", 1, HttpContext, StandardUnit.Count);
            bool result = false;
            var headers = base.HttpContext.Request.Headers["Authorization"];
            if (headers.Any())
            {
                string token = headers[0];
                var helper = new Core.Helpers.ApiHelpers.PermissionHelper();
                result = helper.VerifyToken(token, Core.Helpers.ApiHelpers.HeaderHelper.GetRequestIP(this.HttpContext), HttpContext);
            }

            return new JsonResult(new ApiResponse<bool>()
            {
                RequestStartTime = DateTime.UtcNow,
                RequestEndTime = DateTime.UtcNow,
                Success = true,
                WorkerIdentifier = ConstantsWorker.WorkerIdentifier,                
                ResponseData = result
            });
        }
    }
}