﻿using System;
using System.Linq;
using Microsoft.AspNetCore.Antiforgery;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Resonance.Core;
using Resonance.Core.Extensions;
using Resonance.Core.Models.ApiModels;

namespace Resonance.Api.Microservices.Controllers
{
    /// <summary>
    /// https://www.blinkingcaret.com/2018/11/29/asp-net-core-web-api-antiforgery/
    /// https://odetocode.com/blogs/scott/archive/2017/02/06/anti-forgery-tokens-and-asp-net-core-apis.aspx
    /// </summary>
    [Route("security")]
    //[AutoValidateAntiforgeryToken]
    public class AntiForgeryController : Controller
    {
        private IAntiforgery _antiForgery;
        public AntiForgeryController(IAntiforgery antiForgery)
        {
            _antiForgery = antiForgery;
        }

        [HttpGet("get-xsrf-cookie")]
        public IActionResult GetAntiforgeryCookie()
        {
            var tokens = _antiForgery.GetAndStoreTokens(HttpContext);
            HttpContext.Response.Cookies.Append("XSRF-Token", tokens.RequestToken, new CookieOptions() { HttpOnly = false });
            return NoContent();
        }

        [HttpGet("get-xsrf-token")]
        [IgnoreAntiforgeryToken]
        public IActionResult GetAntiforgeryToken()
        {
            var tokens = _antiForgery.GetAndStoreTokens(HttpContext);
            HttpContext.Response.Cookies.Append("XSRF-Token", tokens.RequestToken, new CookieOptions() { HttpOnly = false });
            return new ObjectResult(new
            {
                form_field_name = tokens.FormFieldName,
                cookie_name =
                    HttpContext.Request.Cookies.Keys.FirstOrDefault(x => x.StartsWith(".AspNetCore.Antiforgery."))
                    ?? HttpContext.Response.GetCookieNameFromResponse(".AspNetCore.Antiforgery.", false),
                cookie_token = tokens.CookieToken,
                header_name = tokens.HeaderName,
                header_token = tokens.RequestToken
            });
        }

        [HttpPost("validate-xsrf-token")]
        public JsonResult ValidateXsrfResult()
        {
            var response = new ApiResponse<string>()
            {
                RequestStartTime = DateTime.UtcNow,
                RequestEndTime = DateTime.UtcNow,
                Success = true,
                ResponseData = "xsrf validated successfully",
                WorkerIdentifier = ConstantsWorker.WorkerIdentifier
            };
            return new JsonResult(response);
        }
    }
}