﻿using Resonance.Core;
using Resonance.Core.Helpers.ApiHelpers;
using Resonance.Core.Models.ConfigurationModels.Permissions;

namespace Resonance.Api.Shared.ViewModels
{
    public class PermissionManagementViewModel
    {
        private static PermissionHelper permissionHelper { get; set; }
        public PermissionConfigurationModel Configuration { get; private set; }

        public PermissionManagementViewModel(string projectName)
        {
            permissionHelper = new PermissionHelper();
            permissionHelper.Initialize();
            if(projectName == "None")
            {
                Configuration = new PermissionConfigurationModel();
            }
            else
            {
                Configuration = permissionHelper.GetPermissionsFromS3(projectName);
                Constants.Permissions = Configuration;
            }
        }
    }
}
