﻿using Resonance.Core;
using Resonance.Core.Helpers.ApiHelpers;
using Resonance.Core.Models.ConfigurationModels.Permissions;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Api.Shared.ViewModels
{
    public class PermissionMigrationViewModel
    {
        private static PermissionHelper permissionHelper { get; set; }
        public PermissionConfigurationModel SourceConfiguration { get; private set; }
        public PermissionConfigurationModel TargetConfiguration { get; private set; }

        public PermissionMigrationViewModel()
        {
            permissionHelper = new PermissionHelper();
            SourceConfiguration = null;
            TargetConfiguration = null;
            permissionHelper.Initialize();
        }

        public PermissionMigrationViewModel(string sourceEnvironment, string targetEnvironment, string projectName)
        {
            permissionHelper = new PermissionHelper();
            permissionHelper.Initialize();

            if (projectName == "None")
            {
                SourceConfiguration = new PermissionConfigurationModel();
                TargetConfiguration = new PermissionConfigurationModel();
            }
            else
            {
                SourceConfiguration = permissionHelper.GetPermissionsFromS3(projectName, sourceEnvironment);
                TargetConfiguration = permissionHelper.GetPermissionsFromS3(projectName, targetEnvironment);
                Constants.Permissions = SourceConfiguration;
            }
        }
    }
}
