using Newtonsoft.Json;
using System;

namespace Resonance.Core.ViewModels
{
    public class ErrorViewModel
    {
        [JsonProperty(PropertyName = "status-code", NullValueHandling = NullValueHandling.Ignore)]
        public int StatusCode { get; set; }
        [JsonProperty(PropertyName = "path", NullValueHandling = NullValueHandling.Ignore)]
        public string Path { get; set; }
        [JsonProperty(PropertyName = "error-message", NullValueHandling = NullValueHandling.Ignore)]
        public string ErrorMessage { get; set; }
        [JsonProperty(PropertyName = "request-id", NullValueHandling = NullValueHandling.Ignore)]
        public string RequestId { get; set; }
        [JsonProperty(PropertyName = "show-request-id", NullValueHandling = NullValueHandling.Ignore)]
        public bool ShowRequestId => !string.IsNullOrEmpty(RequestId);
    }
}