﻿using System;

namespace Resonance.Deploy
{
    class Program
    {
        private const bool deployLocallyOnly = true;

#if CONFIG_DEVELOPMENT
        public const string AppEnvironment = "Development";
        public static string CopyEnvironment = "Debug";
#elif CONFIG_STAGING
        public const string AppEnvironment = "Staging";
        public static string CopyEnvironment = "Staging";
#elif CONFIG_PRODUCTION
        public const string AppEnvironment = "Production";
        public static string CopyEnvironment = "Release";
#endif
        public static readonly string appLogPath = $"/aws/ec2/{AppEnvironment}/resonance/deploy";
        public static string deployScriptPath = $@"C:\Projects\Resonance\DeployScripts\Deploy-{AppEnvironment}.bat";
        public static string deployScriptLocalPath = $@"C:\Projects\Resonance\DeployScripts\Deploy-{AppEnvironment}-LOCAL.bat";
        static void Main(string[] args)
        {
            if (deployLocallyOnly)
            {
                Console.WriteLine(deployScriptPath);
                ExecutePublishSteps(deployScriptLocalPath);
            }
            /*
            else
            {
                Console.WriteLine(deployScriptPath);
                ExecutePublishSteps(deployScriptPath);
            }
            */
        }        

        private static void ExecutePublishSteps(string path)
        {
            System.Diagnostics.Process.Start(path);
        }
    }
}
