﻿using Microsoft.Extensions.Configuration;
using Resonance.Core.Models.ConfigurationModels;
using System;
using System.IO;
using System.Reflection;

namespace Resonance.Jobs.Amp
{
    internal static class AppConfig
    {
        internal static IConfigurationRoot Configuration { get; private set; }
        internal static ApplicationConfigurationModel Data { get; private set; }

        internal static void Initialize(ref string[] args)
        {
            var builder = new ConfigurationBuilder();
            builder.AddCommandLine(args);
            var config = builder.Build();

            var path = Path.GetFullPath($"{Path.GetDirectoryName(Assembly.GetEntryAssembly().Location)}/appsettings.{config["environment"]}.json");

            Configuration = new ConfigurationBuilder()
                .SetBasePath(Directory.GetCurrentDirectory())
                .AddJsonFile($"{path}", optional: false, reloadOnChange: true)
                .Build();

            Data = Configuration.GetSection("Resonance").Get<ApplicationConfigurationModel>();
        }
    }
}
