﻿using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Jobs.Atlas;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Jobs.Amp
{
    public static class CommandManager
    {
        internal static bool quit = false;
        public static void Initialize()
        {
            Log.Info("Initializing Command Manager");

            do
            {
                Console.WriteLine($@"Command?");
                var command = Console.ReadLine();
                if (!string.IsNullOrWhiteSpace(command))
                {
                    switch (command)
                    {
                        case "help":
                        {
                            // Todo: Move commands to a dictionary to echo out all of them with helpful descriptions
                            Console.WriteLine($@"Valid Commands: 'quit', 'forcequit'");
                            break;
                        }
                        case "forcequit":
                        {
                            Log.Warn($@"ForceQuit request received. Application terminating immediately.");
                            quit = true;
                            Program.QuitHandle.Set();
                            Program.GracefulQuitHandle.Set();
                            break;
                        }
                        case "quit":
                        {
                            Log.Info($@"Quit request received. When all jobs complete the application will be exited. Please stand by. . .");
                            quit = true;
                            Program.QuitHandle.Set();
                            break;
                        }
                        default:
                        {
                            Console.WriteLine($@"Invalid command. Try 'help' if you're stuck.");
                            break;
                        }
                    }
                }
            } while (!quit);
        }
    }
}
