﻿/* Disabled 2020-10-09 by TournyMasterBot. Atlas Backfill has been deprecated for a while now, remove after 2021-01-01
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models;
using System;
using Resonance.Core.Models.ConfigurationModels.Jobs;
using Resonance.Core.Services.LdapService;
using Resonance.Core.Helpers.DatabaseHelpers;
using System.Collections.Generic;
using Resonance.Core;
using System.Linq;
using Resonance.Core.Models.DatabaseModels.BackfillModels;
using Resonance.Core.Helpers.StringHelpers;

namespace Resonance.Jobs.Atlas.DataPopulation
{
    public class AtlasBackfill : JobBase, IJob<long>
    {
        private static LdapService ldapService = new LdapService();

        public AtlasBackfill(JobConfiguration _config)
        {
            try
            {
                Config = _config;
                Log.Info($@"AtlasBackfill: configured. IsActive: {Config.IsActive}");
            }
            catch (Exception)
            {

            }
        }

        public override void Run()
        {
            try
            {
                this.Config.IsRunning = true;

                Log.Info("AtlasBackfill: Starting");

                throw new InvalidOperationException("Backfill job is disabled as of Atlas Go Live: 2020-05-13");
                //ExecuteBackfill();
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
            finally
            {
                Log.Info("AtlasBackfill: Done");
                this.Config.IsActive = false;
                this.Config.IsRunning = false;
            }
        }

        /// <summary>
        /// Order of backfill matters, don't change the order unless you know what you're doing.
        /// </summary>
        private void ExecuteBackfill()
        {
            ExecuteLDAPBackfill();
            ExecutePremiumContentCreatorBackfill();
            ExecutePccToAmMap();
            ExecutePccToChannelMap();
            ExecuteProductBackfill();
            ExecuteSeasonBackfill();
            ExecuteEventBackfill();
            ExecuteStreamBackfill();
            ExecuteTopicBackfill();
            ExecuteSubTopicBackfill();
            ExecuteFormatBackfill();
            ExecuteSubFormatBackfill();
            ExecuteContractBackfill();
            ExecuteContractChannelBackfill();
            ExecutePccToContractMap();
        }

        private void ExecutePccToContractMap()
        {
            try
            {
                Log.Info($@"Starting Pcc To Contract Map");

                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText = $@"truncate table {Constants.DatabaseSchema}microservice_twitch_atlas_contract_account_manager_map;";
                        command.ExecuteNonQuery();
                        command.CommandText =
                        $@"
                            insert into development.microservice_twitch_atlas_contract_account_manager_map (contract_id, account_manager_id, is_active, created_time, created_user, hash)
                            select
	                            b.contract_id,
                                a.account_manager_id,
                                true as is_active,
                                @created_time,
                                @created_user,
                                @hash
                            from development.microservice_twitch_atlas_pcc_to_am_map as a
                            inner join development.microservice_twitch_atlas_contracts as b
	                            on a.premium_content_creator_id = b.premium_content_creator_id
                            group by
                                a.account_manager_id,
                                b.contract_id
                            ;
                        ";
                        command.Parameters.AddWithValue("@created_time", DateTime.UtcNow);
                        command.Parameters.AddWithValue("@created_user", "BulkImport");
                        command.Parameters.AddWithValue("@hash", HashHelper.SimpleRandomLetterSequence.RandomHash());
                        command.ExecuteNonQuery();
                        command.Parameters.Clear();
                        command.CommandText = @"truncate table staging.microservice_twitch_atlas_contract_account_manager_map;";
                        command.ExecuteNonQuery();
                        command.CommandText = @"insert into staging.microservice_twitch_atlas_contract_account_manager_map select * from development.microservice_twitch_atlas_contract_account_manager_map order by contract_account_manager_map_id;";
                        command.ExecuteNonQuery();
                        command.CommandText = @"truncate table production.microservice_twitch_atlas_contract_account_manager_map;";
                        command.ExecuteNonQuery();
                        command.CommandText = @"insert into production.microservice_twitch_atlas_contract_account_manager_map select * from development.microservice_twitch_atlas_contract_account_manager_map order by contract_account_manager_map_id;";
                        command.ExecuteNonQuery();
                    }
                }
            }
            catch(Exception ex)
            {
                Log.Error(ex);
            }
            finally
            {
                Log.Info($@"Finished Pcc To Contract Map");
            }
        }

        private void ExecuteContractChannelBackfill()
        {
            var backfill = new List<microservice_twitch_atlas_contract_channels>();

            try
            {
                var sql =
                $@"
                    select
                        contract_id,
                        channel_id,
                        contract_start_date_override as custom_start_date,
                        contract_end_date_override as custom_end_date,
                        true as is_active,
                        insert_timestamp as created_time,
                        'BulkImport' as created_user
                    from metadata.atlas_f_pg_contract_channel
                    ;
                ";

                using (var conn = DBManagerRedshift.TahoeConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText = sql;
                        using (var reader = command.ExecuteReader())
                        {
                            if (reader.HasRows)
                            {
                                while (reader.Read())
                                {
                                    var contractID = reader.GetInt32(0);
                                    var channelID = reader.GetInt64(1);
                                    var startDate = reader.GetValue(2);
                                    var endDate = reader.GetValue(3);
                                    var isActive = reader.GetBoolean(4);
                                    var createTime = reader.GetDateTime(5);
                                    var createUser = reader.GetString(6);

                                    var item = new microservice_twitch_atlas_contract_channels()
                                    {
                                        contract_id = contractID,
                                        channel_id = channelID,
                                        custom_start_date = startDate == null || startDate == DBNull.Value
                                            ? null
                                            : (DateTime?)startDate,
                                        custom_end_date = endDate == null || endDate == DBNull.Value
                                            ? null
                                            : (DateTime?)endDate,
                                        is_active = isActive,
                                        created_time = createTime,
                                        created_user = createUser,
                                        hash = HashHelper.SimpleRandomLetterSequence.RandomHash()
                                    };
                                    backfill.Add(item);
                                }
                            }
                        }
                    }
                }

                Log.Info($@"Found {backfill.Count()} Contract Channel items");

                // Push data to RDS
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        Log.Info($@"Loading development.microservice_twitch_atlas_contract_channels");
                        command.CommandText = $@"truncate table development.microservice_twitch_atlas_contract_channels;";
                        command.ExecuteNonQuery();
                        command.CommandText =
                        $@"
                            replace into development.microservice_twitch_atlas_contract_channels
                            (
                                contract_id, channel_id,
                                custom_start_date, custom_end_date,
                                is_active,created_time,created_user,hash
                            )
                            select
                                @contract_id, @channel_id,
                                @custom_start_date, @custom_end_date,
                                @is_active,@created_time,@created_user,@hash
                            ;
                        ";
                        foreach (var item in backfill)
                        {
                            command.Parameters.Clear();
                            command.Parameters.AddWithValue("@contract_id", item.contract_id);
                            command.Parameters.AddWithValue("@channel_id", item.channel_id);
                            command.Parameters.AddWithValue("@custom_start_date", item.custom_start_date);
                            command.Parameters.AddWithValue("@custom_end_date", item.custom_end_date);
                            command.Parameters.AddWithValue("@is_active", item.is_active);
                            command.Parameters.AddWithValue("@created_time", item.created_time);
                            command.Parameters.AddWithValue("@created_user", item.created_user);
                            command.Parameters.AddWithValue("@hash", item.hash);
                            command.ExecuteNonQuery();
                        }
                        command.Parameters.Clear();
                        Log.Info($@"Loading staging.microservice_twitch_atlas_contract_channels");
                        command.CommandText = $@"truncate table staging.microservice_twitch_atlas_contract_channels;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into staging.microservice_twitch_atlas_contract_channels select * from development.microservice_twitch_atlas_contract_channels;";
                        command.ExecuteNonQuery();
                        Log.Info($@"Loading production.microservice_twitch_atlas_contract_channels");
                        command.CommandText = $@"truncate table production.microservice_twitch_atlas_contract_channels;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into production.microservice_twitch_atlas_contract_channels select * from development.microservice_twitch_atlas_contract_channels;";
                        command.ExecuteNonQuery();
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        private void ExecuteContractBackfill()
        {
            var sql =
            $@"
                select
                  contract_id,
                  contract as contract_name,
                  coalesce(contract_type, 'Unknown') as contract_type,
                  coalesce(organizer_id, -1) as premium_content_creator_id,
                  coalesce(start_date, '1900-01-01'::date) as start_date,
                  coalesce(end_date, '9999-12-31'::date) as end_date,
                  case 
                    when ad_revenue_share = 'Custom Agreement' and custom_rev_share_type is null then false 
                    else true 
                  end revenue_share_enabled,
                  case 
                    when ad_revenue_share like 'Premium%' then 'Premium' 
                    when ad_revenue_share like 'Standard%' then 'Standard' 
                    when ad_revenue_share like 'Custom%' then 'Custom'
                        else 'Unknown'
                  end as ad_revenue_contract_type,
                  case 
                    when ad_revenue_share like 'Premium%' then 'cpm' 
                    when ad_revenue_share like 'Standard%' then 'cpm' 
                    else custom_rev_share_type 
                  end as ad_revenue_share_type_tier_1,
                  (
                    case 
                      when ad_revenue_share like 'Premium%' then 5::float 
                      when ad_revenue_share like 'Standard%' then 3.50::float
                      else custom_rev_share
                    end
                  )::float as ad_revenue_share_amount_tier_1,
                  case 
                    when ad_revenue_share like 'Premium%' then 'cpm' 
                    when ad_revenue_share like 'Standard%' then 'cpm' 
                    else custom_rev_share_type 
                  end as ad_revenue_share_type_tier_2,
                  (
                    case 
                      when ad_revenue_share like 'Premium%' then 3.50::float 
                      when ad_revenue_share like 'Standard%' then 3.50::float
                      else custom_rev_share
                    end
                  )::float as ad_revenue_share_amount_tier_2,
                  case 
                    when ad_revenue_share like 'Premium%' then '% of net' 
                    when ad_revenue_share like 'Standard%' then '% of net' 
                    else custom_rev_share_type 
                  end as ad_revenue_share_type_tier_3,
                  (
                    case 
                      when ad_revenue_share like 'Premium%' then 50.0::float 
                      when ad_revenue_share like 'Standard%' then 50.0::float
                      else custom_rev_share
                    end
                  )::float as ad_revenue_share_amount_tier_3,
                  100.0::float as bits_revenue_share_percent,
                  sub_revenue_share::float * 100.0::float as subs_revenue_share_percent,
                  coalesce(minutes_ads_per_hour, 0) as ad_density_per_hour,
                  coalesce(distribution_exclusivity, false) as exclusivity_enabled,
                  coalesce(preroll_active, false) as ad_prerolls_enabled,
                  coalesce(sponsorship_rights, false) as sponsorship_enabled,
                  true as is_active,
                  coalesce(insert_timestamp, getdate()) as created_time,
                  'BulkImport' as created_user
                from metadata.atlas_f_pg_contract
                ;
            ";

            var backfill = new List<microservice_twitch_atlas_contracts>();
            try
            {
                // Get data from upstream source
                using (var conn = DBManagerRedshift.TahoeConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText = sql;
                        using (var reader = command.ExecuteReader())
                        {
                            if (reader.HasRows)
                            {
                                while (reader.Read())
                                {
                                    var contractID = reader.GetInt32(0);
                                    var contractName = reader.GetString(1);
                                    var contractType = reader.GetString(2);
                                    var pccID = reader.GetInt32(3);
                                    var startDate = reader.GetDateTime(4);
                                    var endDate = reader.GetDateTime(5);
                                    var revenueShareEnabled = reader.GetBoolean(6);
                                    var adRevenueContractType = reader.GetString(7);
                                    var adRevenueTier1Type = reader.GetValue(8);
                                    var adRevenueTier1Amount = reader.GetValue(9);
                                    var adRevenueTier2Type = reader.GetValue(10);
                                    var adRevenueTier2Amount = reader.GetValue(11);
                                    var adRevenueTier3Type = reader.GetValue(12);
                                    var adRevenueTier3Amount = reader.GetValue(13);
                                    var bitsRevenueSharePercent = reader.GetValue(14);
                                    var subsRevenueSharePercent = reader.GetValue(15);
                                    var adDensity = reader.GetValue(16);
                                    var exclusivity = reader.GetValue(17);
                                    var adPrerolls = reader.GetValue(18);
                                    var sponsorship = reader.GetValue(19);
                                    var isActive = reader.GetBoolean(20);
                                    var createdTime = reader.GetDateTime(21);
                                    var createdUser = reader.GetString(22);

                                    var item = new microservice_twitch_atlas_contracts()
                                    {
                                        contract_id = contractID,
                                        contract_name = contractName,
                                        contract_type = contractType,
                                        premium_content_creator_id = pccID,
                                        start_date = startDate,
                                        end_date = endDate,
                                        revenue_share_enabled = revenueShareEnabled,
                                        ad_revenue_contract_type = adRevenueContractType,
                                        ad_revenue_share_type_tier_1 = adRevenueTier1Type == null || adRevenueTier1Type == DBNull.Value
                                            ? null
                                            : (string) adRevenueTier1Type,
                                        ad_revenue_share_amount_tier_1 = adRevenueTier1Amount == null || adRevenueTier1Amount == DBNull.Value
                                            ? null
                                            : (float?)(double) adRevenueTier1Amount,
                                        ad_revenue_share_type_tier_2 = adRevenueTier2Type == null || adRevenueTier2Type == DBNull.Value
                                            ? null
                                            : (string)adRevenueTier2Type,
                                        ad_revenue_share_amount_tier_2 = adRevenueTier2Amount == null || adRevenueTier2Amount == DBNull.Value
                                            ? null
                                            : (float?)(double) adRevenueTier2Amount,
                                        ad_revenue_share_type_tier_3 = adRevenueTier3Type == null || adRevenueTier3Type == DBNull.Value
                                            ? null
                                            : (string)adRevenueTier3Type,
                                        ad_revenue_share_amount_tier_3 = adRevenueTier3Amount == null || adRevenueTier3Amount == DBNull.Value
                                            ? null
                                            : (float?)(double)adRevenueTier3Amount,
                                        bits_revenue_share_percent = bitsRevenueSharePercent == null || bitsRevenueSharePercent == DBNull.Value
                                            ? null
                                            : (float?)(double)bitsRevenueSharePercent,
                                        subs_revenue_share_percent = subsRevenueSharePercent == null || subsRevenueSharePercent == DBNull.Value
                                            ? null
                                            : (float?)(double)subsRevenueSharePercent,
                                        ad_density_per_hour = adDensity == null || adDensity == DBNull.Value
                                            ? null
                                            : (float?)(double)adDensity,
                                        exclusivity_enabled = exclusivity == null || exclusivity == DBNull.Value
                                            ? null
                                            : (bool?) exclusivity,
                                        ad_prerolls_enabled = adPrerolls == null || adPrerolls == DBNull.Value
                                            ? null
                                            : (bool?) adPrerolls,
                                        sponsorship_enabled = sponsorship == null || sponsorship == DBNull.Value
                                            ? null 
                                            : (bool?) sponsorship,
                                        is_active = isActive,
                                        created_time = createdTime,
                                        created_user = createdUser,
                                        hash = HashHelper.SimpleRandomLetterSequence.RandomHash()
                                    };
                                    backfill.Add(item);
                                }
                            }
                        }
                    }
                }

                Log.Info($@"Found {backfill.Count()} Contract items");

                // Push data to RDS
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        Log.Info($@"Loading development.microservice_twitch_atlas_contracts");
                        command.CommandText = $@"truncate table development.microservice_twitch_atlas_contracts;";
                        command.ExecuteNonQuery();
                        command.CommandText =
                        $@"
                            replace into development.microservice_twitch_atlas_contracts
                            (
                                contract_id, contract_name, contract_type, premium_content_creator_id,
                                start_date, end_date, revenue_share_enabled, ad_revenue_contract_type,
                                ad_revenue_share_type_tier_1, ad_revenue_share_amount_tier_1,
                                ad_revenue_share_type_tier_2, ad_revenue_share_amount_tier_2,
                                ad_revenue_share_type_tier_3, ad_revenue_share_amount_tier_3,
                                bits_revenue_share_percent, subs_revenue_share_percent, ad_density_per_hour,
                                exclusivity_enabled, ad_prerolls_enabled, sponsorship_enabled,
                                is_active,created_time,created_user, hash
                            )
                            select
                                @contract_id, @contract_name, @contract_type, @premium_content_creator_id,
                                @start_date, @end_date, @revenue_share_enabled, @ad_revenue_contract_type,
                                @ad_revenue_share_type_tier_1, @ad_revenue_share_amount_tier_1,
                                @ad_revenue_share_type_tier_2, @ad_revenue_share_amount_tier_2,
                                @ad_revenue_share_type_tier_3, @ad_revenue_share_amount_tier_3,
                                @bits_revenue_share_percent, @subs_revenue_share_percent, @ad_density_per_hour,
                                @exclusivity_enabled, @ad_prerolls_enabled, @sponsorship_enabled,
                                @is_active,@created_time,@created_user,@hash
                            ;
                        ";
                        foreach (var item in backfill)
                        {
                            command.Parameters.Clear();
                            command.Parameters.AddWithValue("@contract_id", item.contract_id);
                            command.Parameters.AddWithValue("@contract_name", item.contract_name);
                            command.Parameters.AddWithValue("@contract_type", item.contract_type);
                            command.Parameters.AddWithValue("@premium_content_creator_id", item.premium_content_creator_id);
                            command.Parameters.AddWithValue("@start_date", item.start_date);
                            command.Parameters.AddWithValue("@end_date", item.end_date);
                            command.Parameters.AddWithValue("@revenue_share_enabled", item.revenue_share_enabled);
                            command.Parameters.AddWithValue("@ad_revenue_contract_type", item.ad_revenue_contract_type);
                            command.Parameters.AddWithValue("@ad_revenue_share_type_tier_1", item.ad_revenue_share_type_tier_1);
                            command.Parameters.AddWithValue("@ad_revenue_share_amount_tier_1", item.ad_revenue_share_amount_tier_1);
                            command.Parameters.AddWithValue("@ad_revenue_share_type_tier_2", item.ad_revenue_share_type_tier_2);
                            command.Parameters.AddWithValue("@ad_revenue_share_amount_tier_2", item.ad_revenue_share_amount_tier_2);
                            command.Parameters.AddWithValue("@ad_revenue_share_type_tier_3", item.ad_revenue_share_type_tier_3);
                            command.Parameters.AddWithValue("@ad_revenue_share_amount_tier_3", item.ad_revenue_share_amount_tier_3);
                            command.Parameters.AddWithValue("@bits_revenue_share_percent", item.bits_revenue_share_percent);
                            command.Parameters.AddWithValue("@subs_revenue_share_percent", item.subs_revenue_share_percent);
                            command.Parameters.AddWithValue("@ad_density_per_hour", item.ad_density_per_hour);
                            command.Parameters.AddWithValue("@exclusivity_enabled", item.exclusivity_enabled);
                            command.Parameters.AddWithValue("@ad_prerolls_enabled", item.ad_prerolls_enabled);
                            command.Parameters.AddWithValue("@sponsorship_enabled", item.sponsorship_enabled);
                            command.Parameters.AddWithValue("@is_active", item.is_active);
                            command.Parameters.AddWithValue("@created_time", item.created_time);
                            command.Parameters.AddWithValue("@created_user", item.created_user);
                            command.Parameters.AddWithValue("@hash", item.hash);
                            command.ExecuteNonQuery();
                        }
                        command.Parameters.Clear();
                        Log.Info($@"Loading staging.microservice_twitch_atlas_contracts");
                        command.CommandText = $@"truncate table staging.microservice_twitch_atlas_contracts;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into staging.microservice_twitch_atlas_contracts select * from development.microservice_twitch_atlas_contracts;";
                        command.ExecuteNonQuery();
                        Log.Info($@"Loading production.microservice_twitch_atlas_contracts");
                        command.CommandText = $@"truncate table production.microservice_twitch_atlas_contracts;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into production.microservice_twitch_atlas_contracts select * from development.microservice_twitch_atlas_contracts;";
                        command.ExecuteNonQuery();
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        private void ExecutePccToChannelMap()
        {
            var backfill = new List<microservice_twitch_atlas_pcc_to_channel_map>();
            try
            {
                // Get data from upstream source
                using (var conn = DBManagerRedshift.TahoeConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText =
                        @"
                            select
                                organizer_id as premium_content_creator_id,
                                channel_id,
                                true as is_active,
                                getdate() as created_time,
                                'BulkImport' as created_user
                            from metadata.atlas_f_organizer_channel
                            ;
                        ";
                        using (var reader = command.ExecuteReader())
                        {
                            if (reader.HasRows)
                            {
                                while (reader.Read())
                                {
                                    var organizerID = reader.GetInt32(0);
                                    var channelID = reader.GetInt64(1);
                                    var isActive = reader.GetBoolean(2);
                                    var createdTime = reader.GetDateTime(3);
                                    var createdUser = reader.GetString(4);
                                    var item = new microservice_twitch_atlas_pcc_to_channel_map()
                                    {
                                        premium_content_creator_id = organizerID,
                                        channel_id = channelID,
                                        is_active = isActive,
                                        created_time = createdTime,
                                        created_user = createdUser,
                                        hash = HashHelper.SimpleRandomLetterSequence.RandomHash()
                                    };
                                    backfill.Add(item);
                                }
                            }
                        }
                    }
                }

                Log.Info($@"Found {backfill.Count()} PCC to Channel Map items");

                // Push data to RDS
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        Log.Info($@"Loading development.microservice_twitch_atlas_pcc_to_channel_map");
                        command.CommandText = $@"truncate table development.microservice_twitch_atlas_pcc_to_channel_map;";
                        command.ExecuteNonQuery();
                        command.CommandText =
                        $@"
                            replace into development.microservice_twitch_atlas_pcc_to_channel_map
                            (
                                premium_content_creator_id,channel_id,
                                is_active,created_time,created_user,hash
                            )
                            select @premium_content_creator_id,@channel_id,
                                @is_active,@created_time,@created_user,@hash
                            ;
                        ";
                        foreach(var item in backfill)
                        {
                            command.Parameters.Clear();
                            command.Parameters.AddWithValue("@premium_content_creator_id", item.premium_content_creator_id);
                            command.Parameters.AddWithValue("@channel_id", item.channel_id);
                            command.Parameters.AddWithValue("@is_active", item.is_active);
                            command.Parameters.AddWithValue("@created_time", item.created_time);
                            command.Parameters.AddWithValue("@created_user", item.created_user);
                            command.Parameters.AddWithValue("@hash", item.hash);
                            command.ExecuteNonQuery();
                        }
                        command.Parameters.Clear();
                        Log.Info($@"Loading staging.microservice_twitch_atlas_pcc_to_channel_map");
                        command.CommandText = $@"truncate table staging.microservice_twitch_atlas_pcc_to_channel_map;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into staging.microservice_twitch_atlas_pcc_to_channel_map select * from development.microservice_twitch_atlas_pcc_to_channel_map;";
                        command.ExecuteNonQuery();
                        Log.Info($@"Loading production.microservice_twitch_atlas_pcc_to_channel_map");
                        command.CommandText = $@"truncate table production.microservice_twitch_atlas_pcc_to_channel_map;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into production.microservice_twitch_atlas_pcc_to_channel_map select * from development.microservice_twitch_atlas_pcc_to_channel_map;";
                        command.ExecuteNonQuery();
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        /// <summary>
        /// This should be executed after the LDAP backfill is completed.
        /// </summary>
        private void ExecutePccToAmMap()
        {
            var backfill = new List<microservice_twitch_atlas_premium_content_creator>();
            try
            {
                // Push data to RDS
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        Log.Info($@"Loading development.microservice_twitch_atlas_pcc_to_am_map");
                        command.CommandText = $@"truncate table development.microservice_twitch_atlas_pcc_to_am_map;";
                        command.ExecuteNonQuery();
                        command.CommandText =
                        $@"
                            replace into development.microservice_twitch_atlas_pcc_to_am_map (premium_content_creator_id, account_manager_id, is_active, created_time, created_user, hash)
                            select
                                a.premium_content_creator_id,
                                b.account_manager_id,
                                case when a.is_active = true and b.is_active = true then true else false end as is_active,
                                a.created_time,
                                a.created_user,
                                @hash as hash
                            from development.microservice_twitch_atlas_premium_content_creator as a
                            inner join development.microservice_twitch_atlas_account_manager as b
	                            on a.am_name = concat(b.account_manager_first_name, ' ', b.account_manager_last_name)
                            ;
                        ";
                        command.Parameters.AddWithValue("@hash", HashHelper.SimpleRandomLetterSequence.RandomHash());
                        command.ExecuteNonQuery();
                        Log.Info($@"Loading staging.microservice_twitch_atlas_pcc_to_am_map");
                        command.CommandText = $@"truncate table staging.microservice_twitch_atlas_pcc_to_am_map;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into staging.microservice_twitch_atlas_pcc_to_am_map select * from development.microservice_twitch_atlas_pcc_to_am_map;";
                        command.ExecuteNonQuery();
                        Log.Info($@"Loading production.microservice_twitch_atlas_pcc_to_am_map");
                        command.CommandText = $@"truncate table production.microservice_twitch_atlas_pcc_to_am_map;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into production.microservice_twitch_atlas_pcc_to_am_map select * from development.microservice_twitch_atlas_pcc_to_am_map;";
                        command.ExecuteNonQuery();

                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        private void ExecutePremiumContentCreatorBackfill()
        {
            var backfill = new List<microservice_twitch_atlas_premium_content_creator>();
            try
            {
                // Get data from upstream source
                using (var conn = DBManagerRedshift.TahoeConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText =
                        @"
                            select distinct
                                organizer_id as premium_content_creator_id,
                                organizer as premium_content_creator_name,
                                organizer_type as premium_content_creator_type,
                                null as pcc_am_map_id,
                                getdate() as created_time,
                                'BulkImport' as created_user,
                                organizer_hq_lead as am_name,
                                case when removal_flag = false then true else false end as is_active
                            from metadata.atlas_f_organizer
                            where coalesce(organizer, '') not in ('(Minor Tournament Organizer)','(Other)','(Re-Organizer)','(Unidentified)','(Minor Publisher Announcements)','(Minor Publisher Esports)')
                            ;
                        ";
                        using (var reader = command.ExecuteReader())
                        {
                            if (reader.HasRows)
                            {
                                while (reader.Read())
                                {
                                    var organizerID = reader.GetInt32(0);
                                    var organizer = reader.GetString(1);
                                    var organizerType = reader.GetString(2);
                                    var pccAmMapID = reader.GetValue(3);
                                    var createdTime = reader.GetDateTime(4);
                                    var createdUser = reader.GetString(5);
                                    var amLead = reader.GetValue(6);
                                    var isActive = reader.GetBoolean(7);

                                    var item = new microservice_twitch_atlas_premium_content_creator()
                                    {
                                        premium_content_creator_id = organizerID,
                                        premium_content_creator_name = organizer,
                                        premium_content_creator_type = organizerType,
                                        created_time = createdTime,
                                        created_user = createdUser,
                                        is_active = isActive,
                                        am_name = amLead == null || amLead == DBNull.Value
                                            ? null
                                            : (string)amLead,
                                        hash = HashHelper.SimpleRandomLetterSequence.RandomHash()
                                    };
                                    backfill.Add(item);
                                }
                            }
                        }
                    }
                }

                Log.Info($@"Found {backfill.Count()} Premium Content Creator items");

                // Push data to RDS
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        Log.Info($@"Loading development.microservice_twitch_atlas_premium_content_creator");
                        command.CommandText = $@"truncate table development.microservice_twitch_atlas_premium_content_creator;";
                        command.ExecuteNonQuery();
                        command.CommandText =
                        $@"
                            replace into development.microservice_twitch_atlas_premium_content_creator
                            (
                                premium_content_creator_id, premium_content_creator_name, premium_content_creator_type, 
                                is_active,created_time,created_user,hash,
                                am_name
                            )
                            select
                                @premium_content_creator_id, @premium_content_creator_name, @premium_content_creator_type, 
                                @is_active,@created_time,@created_user,@hash,
                                @am_name
                            ;
                        ";
                        foreach (var item in backfill)
                        {
                            command.Parameters.Clear();
                            command.Parameters.AddWithValue("@premium_content_creator_id", item.premium_content_creator_id);
                            command.Parameters.AddWithValue("@premium_content_creator_name", item.premium_content_creator_name);
                            command.Parameters.AddWithValue("@premium_content_creator_type", item.premium_content_creator_type);
                            command.Parameters.AddWithValue("@is_active", item.is_active);
                            command.Parameters.AddWithValue("@created_time", item.created_time);
                            command.Parameters.AddWithValue("@created_user", item.created_user);
                            command.Parameters.AddWithValue("@am_name", item.am_name);
                            command.Parameters.AddWithValue("@hash", item.hash);
                            command.ExecuteNonQuery();
                        }
                        command.Parameters.Clear();
                        Log.Info($@"Loading staging.microservice_twitch_atlas_premium_content_creator");
                        command.CommandText = $@"truncate table staging.microservice_twitch_atlas_premium_content_creator;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into staging.microservice_twitch_atlas_premium_content_creator select * from development.microservice_twitch_atlas_premium_content_creator;";
                        command.ExecuteNonQuery();
                        Log.Info($@"Loading production.microservice_twitch_atlas_premium_content_creator");
                        command.CommandText = $@"truncate table production.microservice_twitch_atlas_premium_content_creator;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into production.microservice_twitch_atlas_premium_content_creator select * from development.microservice_twitch_atlas_premium_content_creator;";
                        command.ExecuteNonQuery();
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        private void ExecuteProductBackfill()
        {
            var backfill = new List<microservice_twitch_atlas_product>();
            try
            {
                // Get data from upstream source
                using (var conn = DBManagerRedshift.TahoeConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText =
                        @"
                            select distinct
                                a.product_id,
                                coalesce(a.product_name, '') as product_name,
                                coalesce(b.organizer, '') as product_owner,
                                topic,
                                subtopic,
                                null as format,
                                null as sub_format,
                                case when removal_flag = false then true else false end as is_active,
                                coalesce(insert_timestamp, getdate()) as created_time,
                                'BulkImport' as created_user,
                                null as product_description,
                                a.organizer_id as premium_content_creator_id
                            from metadata.atlas_f_product as a
                            left join metadata.atlas_f_organizer as b
                            on a.organizer_id = b.organizer_id
                            where coalesce(b.organizer, '') not in ('(Minor Tournament Organizer)','(Other)','(Re-Organizer)','(Unidentified)','(Minor Publisher Announcements)','(Minor Publisher Esports)')
                            order by product_id
                            ;
                        ";
                        using (var reader = command.ExecuteReader())
                        {
                            if (reader.HasRows)
                            {
                                while (reader.Read())
                                {
                                    var productID = reader.GetInt32(0);
                                    var productName = reader.GetString(1);
                                    var productOwner = reader.GetString(2);
                                    var topic = reader.GetValue(3);
                                    var subTopic = reader.GetValue(4);
                                    var format = reader.GetValue(5);
                                    var subFormat = reader.GetValue(6);
                                    var isActive = reader.GetBoolean(7);
                                    var createdTime = reader.GetDateTime(8);
                                    var createdUser = reader.GetString(9);
                                    var productDescription = reader.GetValue(10);
                                    var pccID = reader.GetInt32(11);

                                    var item = new microservice_twitch_atlas_product()
                                    {
                                        product_id = productID,
                                        product_name = productName,
                                        product_owner = productOwner,
                                        topic = topic == null || topic == DBNull.Value
                                            ? null
                                            : (string)topic,
                                        sub_topic = subTopic == null || subTopic == DBNull.Value
                                            ? null
                                            : (string)subTopic,
                                        format = format == null || format == DBNull.Value
                                            ? null
                                            : (string)format,
                                        sub_format = subFormat == null || subFormat == DBNull.Value
                                            ? null
                                            : (string)subFormat,
                                        is_active = isActive,
                                        created_time = createdTime,
                                        created_user = createdUser,
                                        product_description = productDescription == null || productDescription == DBNull.Value
                                            ? null
                                            : (string)productDescription,
                                        hash = HashHelper.SimpleRandomLetterSequence.RandomHash(),
                                        premium_content_creator_id = pccID
                                    };
                                    backfill.Add(item);
                                }
                            }
                        }
                    }
                }

                Log.Info($@"Found {backfill.Count()} Product items");

                // Push data to RDS
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        Log.Info($@"Loading development.microservice_twitch_atlas_product");
                        command.CommandText = $@"truncate table development.microservice_twitch_atlas_product;";
                        command.ExecuteNonQuery();
                        command.CommandText =
                        $@"
                            replace into development.microservice_twitch_atlas_product
                            (
                                product_id,product_name,product_owner,
                                topic,sub_topic,format,sub_format,
                                is_active,created_time,created_user,hash,
                                premium_content_creator_id
                            )
                            select 
                                @product_id,@product_name,@product_owner,
                                @topic,@sub_topic,@format,@sub_format,
                                @is_active,@created_time,@created_user,@hash,
                                @premium_content_creator_id
                        ";
                        foreach (var item in backfill)
                        {
                            command.Parameters.Clear();
                            command.Parameters.AddWithValue("@product_id", item.product_id);
                            command.Parameters.AddWithValue("@product_name", item.product_name);
                            command.Parameters.AddWithValue("@product_owner", item.product_owner);
                            command.Parameters.AddWithValue("@topic", item.topic);
                            command.Parameters.AddWithValue("@sub_topic", item.sub_topic);
                            command.Parameters.AddWithValue("@format", item.format);
                            command.Parameters.AddWithValue("@sub_format", item.sub_format);
                            command.Parameters.AddWithValue("@is_active", item.is_active);
                            command.Parameters.AddWithValue("@created_time", item.created_time);
                            command.Parameters.AddWithValue("@created_user", item.created_user);
                            command.Parameters.AddWithValue("@hash", item.hash);
                            command.Parameters.AddWithValue("@premium_content_creator_id", item.premium_content_creator_id);
                            command.ExecuteNonQuery();
                        }
                        command.Parameters.Clear();
                        Log.Info($@"Loading staging.microservice_twitch_atlas_product");
                        command.CommandText = $@"truncate table staging.microservice_twitch_atlas_product;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into staging.microservice_twitch_atlas_product select * from development.microservice_twitch_atlas_product;";
                        command.ExecuteNonQuery();
                        Log.Info($@"Loading production.microservice_twitch_atlas_product");
                        command.CommandText = $@"truncate table production.microservice_twitch_atlas_product;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into production.microservice_twitch_atlas_product select * from development.microservice_twitch_atlas_product;";
                        command.ExecuteNonQuery();
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        private void ExecuteSeasonBackfill()
        {
            var backfill = new List<microservice_twitch_atlas_season>();
            try
            {
                // Get data from upstream source
                using (var conn = DBManagerRedshift.TahoeConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText =
                        @"
                            with seasons as
                            (
                              select
                                a.season_id::int, 
                                a.product_id::int, 
                                a.season_name::varchar,
                                (coalesce(min(event_start_time at time zone 'pst' at time zone 'utc') , '1900-01-01'))::datetime as start_time,
                                (coalesce(max(event_end_time at time zone 'pst' at time zone 'utc'), '9999-12-31'))::datetime as end_time,
                                DATEDIFF(hour, (coalesce(min(event_start_time at time zone 'pst' at time zone 'utc') , '1900-01-01'))::datetime, (coalesce(max(event_end_time at time zone 'pst' at time zone 'utc'), '9999-12-31'))::datetime)::float as pledged_hours_broadcast,
                                null as prize_pool,
                                true as is_active,
                                getdate() as created_time,
                                'BulkImport' as created_user
                              from metadata.atlas_f_product_season as a
                              left join metadata.atlas_f_event_broadcast_channel as b
                                on a.season_id = b.season_id
                              group by
                                a.season_id,
                                a.product_id,
                                a.season_name
                            ),
                            previous_season as
                            (
                              select
                                *,
                                (select max(season_id) from seasons as b where a.product_id = b.product_id and b.season_id < a.season_id) as previous_season_id
                              from
                                seasons as a
                            )
                            select
                              a.*,
                              b.season_name as previous_season_name
                            from previous_season as a
                            left join seasons as b
                              on a.previous_season_id = b.season_id
                            order by season_id, product_id;
                            ;
                        ";
                        using (var reader = command.ExecuteReader())
                        {
                            if (reader.HasRows)
                            {
                                while (reader.Read())
                                {
                                    var seasonID = reader.GetInt32(0);
                                    var productID = reader.GetInt32(1);
                                    var seasonName = reader.GetString(2);
                                    var startTime = reader.GetDateTime(3);
                                    var endTime = reader.GetDateTime(4);
                                    var pledgedBroadcastHours = reader.GetDouble(5);
                                    var prizePool = reader.GetValue(6);
                                    var isActive = reader.GetBoolean(7);
                                    var createdTime = reader.GetDateTime(8);
                                    var createdUser = reader.GetString(9);
                                    var previousSeasonID = reader.GetValue(10);
                                    var previousSeasonName = reader.GetValue(11);
                                    var item = new microservice_twitch_atlas_season();
                                    try
                                    {
                                        item.season_id = seasonID;
                                        item.product_id = productID;
                                        item.season_name = seasonName;
                                        item.start_time = startTime;
                                        item.end_time = endTime;
                                        item.pledged_hours_broadcast = (float?)pledgedBroadcastHours;
                                        item.prize_pool = prizePool == null || prizePool == DBNull.Value
                                            ? null
                                            : (float?)prizePool;
                                        item.is_active = isActive;
                                        item.created_time = createdTime;
                                        item.created_user = createdUser;
                                        item.previous_season_id = previousSeasonID == null || previousSeasonID == DBNull.Value
                                            ? null
                                            : (int?)previousSeasonID;
                                        item.previous_season_name = previousSeasonName == null || previousSeasonName == DBNull.Value
                                            ? null
                                            : (string)previousSeasonName;
                                        item.hash = HashHelper.SimpleRandomLetterSequence.RandomHash();
                                    }
                                    catch (Exception ex)
                                    {
                                        Log.Error(ex);
                                    }
                                    if (item != null && !string.IsNullOrWhiteSpace(item.hash))
                                    {
                                        backfill.Add(item);
                                    }
                                }
                            }
                        }
                    }
                }

                Log.Info($@"Found {backfill.Count()} Season items");

                // Push data to RDS
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        Log.Info($@"Loading development.microservice_twitch_atlas_season");
                        command.CommandText = $@"truncate table development.microservice_twitch_atlas_season;";
                        command.ExecuteNonQuery();
                        command.CommandText =
                        $@"
                            replace into development.microservice_twitch_atlas_season
                            (
                                season_id,product_id,season_name,start_time,end_time,
                                pledged_hours_broadcast,prize_pool,
                                is_active,created_time,created_user,hash,
                                previous_season_id, previous_season_name
                            )
                            select
                                @season_id,@product_id,@season_name,@start_time,@end_time,
                                @pledged_hours_broadcast,@prize_pool,
                                @is_active,@created_time,@created_user,@hash,
                                @previous_season_id, @previous_season_name
                            ;
                        ";
                        foreach (var item in backfill)
                        {
                            command.Parameters.Clear();
                            command.Parameters.AddWithValue("@season_id", item.season_id);
                            command.Parameters.AddWithValue("@product_id", item.product_id);
                            command.Parameters.AddWithValue("@season_name", item.season_name);
                            command.Parameters.AddWithValue("@start_time", item.start_time);
                            command.Parameters.AddWithValue("@end_time", item.end_time);
                            command.Parameters.AddWithValue("@pledged_hours_broadcast", item.pledged_hours_broadcast);
                            command.Parameters.AddWithValue("@prize_pool", item.prize_pool);
                            command.Parameters.AddWithValue("@is_active", item.is_active);
                            command.Parameters.AddWithValue("@created_time", item.created_time);
                            command.Parameters.AddWithValue("@created_user", item.created_user);
                            command.Parameters.AddWithValue("@hash", item.hash);
                            command.Parameters.AddWithValue("@previous_season_id", item.previous_season_id);
                            command.Parameters.AddWithValue("@previous_season_name", item.previous_season_name);
                            command.ExecuteNonQuery();
                        }
                        command.Parameters.Clear();
                        Log.Info($@"Loading staging.microservice_twitch_atlas_season");
                        command.CommandText = $@"truncate table staging.microservice_twitch_atlas_season;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into staging.microservice_twitch_atlas_season select * from development.microservice_twitch_atlas_season;";
                        command.ExecuteNonQuery();
                        Log.Info($@"Loading production.microservice_twitch_atlas_season");
                        command.CommandText = $@"truncate table production.microservice_twitch_atlas_season;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into production.microservice_twitch_atlas_season select * from development.microservice_twitch_atlas_season;";
                        command.ExecuteNonQuery();
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        private void ExecuteStreamBackfill()
        {
            var backfill = new List<microservice_twitch_atlas_stream>();
            try
            {
                // Get data from upstream source
                using (var conn = DBManagerRedshift.TahoeConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText =
                        @"
                            select
                              event_id,
                              channel_id,
                              channel as stream_login,
                              event_game as game_name,
                              event_start_time at time zone 'pst' at time zone 'utc' as start_time,
                              event_end_time at time zone 'pst' at time zone 'utc' as end_time,
                              coalesce(channel_type, 'Unknown') as channel_type,
                              true as is_active,
                              insert_timestamp as created_time,
                              'BulkImport' as created_user
                            from metadata.atlas_f_event_broadcast_channel
                            ;
                        ";
                        using (var reader = command.ExecuteReader())
                        {
                            if (reader.HasRows)
                            {
                                while (reader.Read())
                                {
                                    var eventID = reader.GetInt32(0);
                                    var channelID = reader.GetInt32(1);
                                    var login = reader.GetString(2);
                                    var gameName = reader.GetValue(3);
                                    var startTime = reader.GetValue(4);
                                    var endTime = reader.GetValue(5);
                                    var channelType = reader.GetString(6);
                                    var isActive = reader.GetBoolean(7);
                                    var createdTime = reader.GetDateTime(8);
                                    var createdUser = reader.GetString(9);
                                    var item = new microservice_twitch_atlas_stream()
                                    {
                                        event_id = eventID,
                                        channel_id = channelID,
                                        stream_login = login,
                                        game_name = gameName == null || gameName == DBNull.Value
                                            ? null
                                            : (string)gameName,
                                        start_time = startTime == null || startTime == DBNull.Value
                                            ? null
                                            : (DateTime?) startTime,
                                        end_time = endTime == null || endTime == DBNull.Value
                                            ? null
                                            : (DateTime?)endTime,
                                        channel_type = channelType,
                                        is_active = isActive,
                                        created_time = createdTime,
                                        created_user = createdUser,
                                        hash = HashHelper.SimpleRandomLetterSequence.RandomHash()
                                    };
                                    backfill.Add(item);
                                }
                            }
                        }
                    }
                }

                Log.Info($@"Found {backfill.Count()} Stream items");

                // Push data to RDS
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        Log.Info($@"Loading development.microservice_twitch_atlas_stream");
                        command.CommandText = $@"truncate table development.microservice_twitch_atlas_stream;";
                        command.ExecuteNonQuery();
                        command.CommandText =
                        $@"
                            replace into development.microservice_twitch_atlas_stream
                            (
                                event_id, channel_id, stream_login, game_name, 
                                start_time, end_time, channel_type,
                                is_active, created_time, created_user, hash
                            )
                            select
                                @event_id, @channel_id, @stream_login, @game_name, 
                                @start_time, @end_time, @channel_type,
                                @is_active, @created_time, @created_user, @hash
                            ;
                        ";
                        foreach (var item in backfill)
                        {
                            command.Parameters.Clear();
                            command.Parameters.AddWithValue("@event_id", item.event_id);
                            command.Parameters.AddWithValue("@channel_id", item.channel_id);
                            command.Parameters.AddWithValue("@stream_login", item.stream_login);
                            command.Parameters.AddWithValue("@game_name", item.game_name);
                            command.Parameters.AddWithValue("@start_time", item.start_time);
                            command.Parameters.AddWithValue("@end_time", item.end_time);
                            command.Parameters.AddWithValue("@channel_type", item.channel_type);
                            command.Parameters.AddWithValue("@is_active", item.is_active);
                            command.Parameters.AddWithValue("@created_time", item.created_time);
                            command.Parameters.AddWithValue("@created_user", item.created_user);
                            command.Parameters.AddWithValue("@hash", item.hash);
                            command.ExecuteNonQuery();
                        }
                        command.Parameters.Clear();
                        Log.Info($@"Loading staging.microservice_twitch_atlas_stream");
                        command.CommandText = $@"truncate table staging.microservice_twitch_atlas_stream;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into staging.microservice_twitch_atlas_stream select * from development.microservice_twitch_atlas_stream;";
                        command.ExecuteNonQuery();
                        Log.Info($@"Loading production.microservice_twitch_atlas_stream");
                        command.CommandText = $@"truncate table production.microservice_twitch_atlas_stream;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into production.microservice_twitch_atlas_stream select * from development.microservice_twitch_atlas_stream;";
                        command.ExecuteNonQuery();

                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        private void ExecuteEventBackfill()
        {
            var backfill = new List<microservice_twitch_atlas_event>();
            try
            {
                // Get data from upstream source
                using (var conn = DBManagerRedshift.TahoeConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText =
                        @"
                            select distinct
	                            event_id::int as event_id,
	                            season_id::int,
	                            product_id::int,
	                            coalesce(event_name, '') as event_name,
	                            coalesce(organizer_id, 0) as premium_content_creator_id,
	                            event_start_time at time zone 'pst' at time zone 'utc' as start_time,
	                            event_end_time at time zone 'pst' at time zone 'utc' as end_time,
	                            topic,
	                            subtopic as sub_topic,
	                            format,
	                            subformat as sub_format,
	                            true as is_active,
	                            event_type,
	                            coalesce(est_avg_ccv, 0)::float as estimated_average_ccv,
	                            coalesce(est_content_duration::float, 0)::float as pledged_hours_broadcast,
	                            getdate() as created_time,
	                            'BulkImport' as created_user,
	                            event_game as game_name,
	                            distribution_exclusivity as distribution,
	                            twitch_involvement,
	                            null as costreaming_settings
                            from metadata.atlas_f_event_broadcast_channel
                            ;
                        ";
                        using (var reader = command.ExecuteReader())
                        {
                            if (reader.HasRows)
                            {
                                while (reader.Read())
                                {
                                    var eventID = reader.GetInt32(0);
                                    var seasonID = reader.GetValue(1);
                                    var productID = reader.GetValue(2);
                                    var eventName = reader.GetString(3);
                                    var premium_content_creator_id = reader.GetInt32(4);
                                    var startTime = reader.GetDateTime(5);
                                    var endTime = reader.GetDateTime(6);
                                    var topic = reader.GetValue(7);
                                    var subTopic = reader.GetValue(8);
                                    var format = reader.GetValue(9);
                                    var subFormat = reader.GetValue(10);
                                    var isActive = reader.GetBoolean(11);
                                    var eventType = reader.GetString(12);
                                    var estimatedAverageCcu = reader.GetDouble(13);
                                    var pledgedHoursBroadcast = reader.GetDouble(14);
                                    var createdTime = reader.GetDateTime(15);
                                    var createdUser = reader.GetString(16);
                                    var eventGame = reader.GetValue(17);
                                    var distributionExclusivity = reader.GetValue(18);
                                    var twitchInvolvement = reader.GetValue(19);
                                    var costreamSettings = reader.GetValue(20);
                                    try
                                    {
                                        var item = new microservice_twitch_atlas_event();
                                        item.event_id = eventID;
                                        item.season_id = seasonID == null || seasonID == DBNull.Value
                                            ? null
                                            : (int?)seasonID;
                                        item.product_id = productID == null || productID == DBNull.Value
                                            ? null
                                            : (int?)productID;
                                        item.event_name = eventName;
                                        item.premium_content_creator_id = premium_content_creator_id;
                                        item.start_time = startTime;
                                        item.end_time = endTime;
                                        item.topic = topic == null || topic == DBNull.Value
                                            ? null
                                            : (string)topic;
                                        item.sub_topic = subTopic == null || subTopic == DBNull.Value
                                            ? null
                                            : (string)subTopic;
                                        item.is_active = isActive;
                                        item.event_type = eventType;
                                        item.estimated_average_ccv = (float?)estimatedAverageCcu;
                                        item.pledged_hours_broadcast = (float?)pledgedHoursBroadcast;
                                        item.format = format == null || format == DBNull.Value
                                                ? null
                                                : (string)format;
                                        item.sub_format = subFormat == null || subFormat == DBNull.Value
                                                ? null
                                                : (string)subFormat;
                                        item.created_time = createdTime;
                                        item.created_user = createdUser;
                                        item.game_name = eventGame == null || eventGame == DBNull.Value
                                            ? null
                                            : (string)eventGame;
                                        item.distribution = distributionExclusivity == null || distributionExclusivity == DBNull.Value
                                            ? false
                                            : (bool)distributionExclusivity;
                                        item.twitch_involvement = twitchInvolvement == null || twitchInvolvement == DBNull.Value
                                            ? null
                                            : (string)twitchInvolvement;
                                        item.costreaming_settings = costreamSettings == null || costreamSettings == DBNull.Value
                                            ? null
                                            : (string)costreamSettings;
                                        item.hash = HashHelper.SimpleRandomLetterSequence.RandomHash();
                                        backfill.Add(item);
                                    }
                                    catch (Exception ex)
                                    {
                                        Log.Error(ex);
                                    }
                                }
                            }
                        }
                    }
                }

                Log.Info($@"Found {backfill.Count()} Event items");

                // Push data to RDS
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        Log.Info($@"Loading development.microservice_twitch_atlas_event");
                        command.CommandText = $@"truncate table development.microservice_twitch_atlas_event;";
                        command.ExecuteNonQuery();
                        command.CommandText =
                        $@"
                            replace into development.microservice_twitch_atlas_event
                            (
                                event_id, season_id, product_id, event_name, premium_content_creator_id,
                                start_time, end_time, topic, sub_topic, format, sub_format,
                                event_type, estimated_average_ccv, pledged_hours_broadcast, 
                                is_active,created_time,created_user,hash, 
                                game_name, distribution, twitch_involvement, costreaming_settings
                            )
                            select
                                @event_id, @season_id, @product_id, @event_name, @premium_content_creator_id,
                                @start_time, @end_time, @topic, @sub_topic, @format, @sub_format,
                                @event_type, @estimated_average_ccv, @pledged_hours_broadcast, 
                                @is_active,@created_time,@created_user,@hash,
                                @game_name, @distribution, @twitch_involvement, @costreaming_settings
                        ";
                        foreach (var item in backfill)
                        {
                            command.Parameters.Clear();
                            command.Parameters.AddWithValue("@event_id", item.event_id);
                            command.Parameters.AddWithValue("@season_id", item.season_id);
                            command.Parameters.AddWithValue("@product_id", item.product_id);
                            command.Parameters.AddWithValue("@event_name", item.event_name);
                            command.Parameters.AddWithValue("@premium_content_creator_id", item.premium_content_creator_id);
                            command.Parameters.AddWithValue("@start_time", item.start_time);
                            command.Parameters.AddWithValue("@end_time", item.end_time);
                            command.Parameters.AddWithValue("@topic", item.topic);
                            command.Parameters.AddWithValue("@sub_topic", item.sub_topic);
                            command.Parameters.AddWithValue("@format", item.format);
                            command.Parameters.AddWithValue("@sub_format", item.sub_format);
                            command.Parameters.AddWithValue("@event_type", item.event_type);
                            command.Parameters.AddWithValue("@estimated_average_ccv", item.estimated_average_ccv);
                            command.Parameters.AddWithValue("@pledged_hours_broadcast", item.pledged_hours_broadcast);
                            command.Parameters.AddWithValue("@is_active", item.is_active);
                            command.Parameters.AddWithValue("@created_time", item.created_time);
                            command.Parameters.AddWithValue("@created_user", item.created_user);
                            command.Parameters.AddWithValue("@hash", item.hash);
                            command.Parameters.AddWithValue("@game_name", item.game_name);
                            command.Parameters.AddWithValue("@distribution", item.distribution);
                            command.Parameters.AddWithValue("@twitch_involvement", item.twitch_involvement);
                            command.Parameters.AddWithValue("@costreaming_settings", item.costreaming_settings);
                            command.ExecuteNonQuery();
                        }
                        command.Parameters.Clear();
                        Log.Info($@"Loading staging.microservice_twitch_atlas_event");
                        command.CommandText = $@"truncate table staging.microservice_twitch_atlas_event;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into staging.microservice_twitch_atlas_event select * from development.microservice_twitch_atlas_event;";
                        command.ExecuteNonQuery();
                        Log.Info($@"Loading production.microservice_twitch_atlas_event");
                        command.CommandText = $@"truncate table production.microservice_twitch_atlas_event;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into production.microservice_twitch_atlas_event select * from development.microservice_twitch_atlas_event;";
                        command.ExecuteNonQuery();
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        private void ExecuteSubFormatBackfill()
        {
            var backfill = new List<microservice_twitch_atlas_sub_formats>();
            try
            {
                // Get data from upstream source
                using (var conn = DBManagerRedshift.TahoeConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText =
                        @"
                            select
                                subformat_id as sub_format_id,
                                format_id,
                                subformat as sub_format_name,
                                null as sub_format_description,
                                true as is_active,
                                getdate() as created_time,
                                'BulkImport' as created_user
                            from metadata.atlas_d_subformat
                            where coalesce(subformat_id, 0) <> 0
                            order by format_id
                            ;

                        ";
                        using (var reader = command.ExecuteReader())
                        {
                            if (reader.HasRows)
                            {
                                while (reader.Read())
                                {
                                    var subformatID = reader.GetInt32(0);
                                    var formatID = reader.GetInt32(1);
                                    var subformatName = reader.GetString(2);
                                    var subformatDescription = reader.GetValue(3);
                                    var isActive = reader.GetBoolean(4);
                                    var createdTime = reader.GetDateTime(5);
                                    var createdUser = reader.GetString(6);
                                    var item = new microservice_twitch_atlas_sub_formats()
                                    {
                                        sub_format_id = subformatID,
                                        format_id = formatID,
                                        sub_format_name = subformatName,
                                        sub_format_description = subformatDescription == null || subformatDescription == DBNull.Value
                                            ? null
                                            : (string)subformatDescription,
                                        is_active = isActive,
                                        created_time = createdTime,
                                        created_user = createdUser,
                                        hash = HashHelper.SimpleRandomLetterSequence.RandomHash()
                                    };
                                    backfill.Add(item);
                                }
                            }
                        }
                    }
                }

                Log.Info($@"Found {backfill.Count()} SubFormat items");

                // Push data to RDS
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        Log.Info($@"Loading development.microservice_twitch_atlas_sub_formats");
                        command.CommandText = $@"truncate table development.microservice_twitch_atlas_sub_formats;";
                        command.ExecuteNonQuery();
                        command.CommandText =
                        $@"
                            replace into development.microservice_twitch_atlas_sub_formats
                            (
                                sub_format_id, format_id, sub_format_name, sub_format_description, 
                                is_active,created_time,created_user,hash
                            )
                            select
                                @sub_format_id, @format_id, @sub_format_name, @sub_format_description, 
                                @is_active,@created_time,@created_user,@hash
                            ;
                        ";
                        foreach (var item in backfill)
                        {
                            command.Parameters.Clear();
                            command.Parameters.AddWithValue("@sub_format_id", item.sub_format_id);
                            command.Parameters.AddWithValue("@format_id", item.format_id);
                            command.Parameters.AddWithValue("@sub_format_name", item.sub_format_name);
                            command.Parameters.AddWithValue("@sub_format_description", item.sub_format_description);
                            command.Parameters.AddWithValue("@is_active", item.is_active);
                            command.Parameters.AddWithValue("@created_time", item.created_time);
                            command.Parameters.AddWithValue("@created_user", item.created_user);
                            command.Parameters.AddWithValue("@hash", item.hash);
                            command.ExecuteNonQuery();
                        }
                        command.Parameters.Clear();
                        Log.Info($@"Loading staging.microservice_twitch_atlas_sub_formats");
                        command.CommandText = $@"truncate table staging.microservice_twitch_atlas_sub_formats;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into staging.microservice_twitch_atlas_sub_formats select * from development.microservice_twitch_atlas_sub_formats;";
                        command.ExecuteNonQuery();
                        Log.Info($@"Loading production.microservice_twitch_atlas_sub_formats");
                        command.CommandText = $@"truncate table production.microservice_twitch_atlas_sub_formats;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into production.microservice_twitch_atlas_sub_formats select * from development.microservice_twitch_atlas_sub_formats;";
                        command.ExecuteNonQuery();
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        private void ExecuteFormatBackfill()
        {
            var backfill = new List<microservice_twitch_atlas_formats>();
            try
            {
                // Get data from upstream source
                using (var conn = DBManagerRedshift.TahoeConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText =
                        @"
                            select
                                format_id,
                                topic_id,
                                format as format_name,
                                null as format_description,
                                true as is_active,
                                getdate() as created_time,
                                'BulkImport' as created_user
                            from metadata.atlas_d_format
                            order by format_id
                            ;
                        ";
                        using (var reader = command.ExecuteReader())
                        {
                            if (reader.HasRows)
                            {
                                while (reader.Read())
                                {
                                    var formatID = reader.GetInt32(0);
                                    var topicID = reader.GetInt32(1);
                                    var formatName = reader.GetString(2);
                                    var formatDescription = reader.GetValue(3);
                                    var isActive = reader.GetBoolean(4);
                                    var createdTime = reader.GetDateTime(5);
                                    var createdUser = reader.GetString(6);
                                    var item = new microservice_twitch_atlas_formats()
                                    {
                                        format_id = formatID,
                                        topic_id = topicID,
                                        format_name = formatName,
                                        format_description = formatDescription == null || formatDescription == DBNull.Value
                                            ? null
                                            : (string) formatDescription,
                                        is_active = isActive,
                                        created_time = createdTime,
                                        created_user = createdUser,
                                        hash = HashHelper.SimpleRandomLetterSequence.RandomHash()
                                    };
                                    backfill.Add(item);
                                }
                            }
                        }
                    }
                }

                Log.Info($@"Found {backfill.Count()} Format items");

                // Push data to RDS
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        Log.Info($@"Loading development.microservice_twitch_atlas_formats");
                        command.CommandText = $@"truncate table development.microservice_twitch_atlas_formats;";
                        command.ExecuteNonQuery();
                        command.CommandText =
                        $@"
                            replace into development.microservice_twitch_atlas_formats
                            (
                                format_id, topic_id, format_name, format_description,
                                is_active,created_time,created_user,hash
                            )
                            select
                                @format_id, @topic_id, @format_name, @format_description,
                                @is_active, @created_time, @created_user,@hash
                            ;
                        ";
                        foreach (var item in backfill)
                        {
                            command.Parameters.Clear();
                            command.Parameters.AddWithValue("@format_id", item.format_id);
                            command.Parameters.AddWithValue("@topic_id", item.topic_id);
                            command.Parameters.AddWithValue("@format_name", item.format_name);
                            command.Parameters.AddWithValue("@format_description", item.format_description);
                            command.Parameters.AddWithValue("@is_active", item.is_active);
                            command.Parameters.AddWithValue("@created_time", item.created_time);
                            command.Parameters.AddWithValue("@created_user", item.created_user);
                            command.Parameters.AddWithValue("@hash", item.hash);
                            command.ExecuteNonQuery();
                        }
                        command.Parameters.Clear();
                        Log.Info($@"Loading staging.microservice_twitch_atlas_formats");
                        command.CommandText = $@"truncate table staging.microservice_twitch_atlas_formats;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into staging.microservice_twitch_atlas_formats select * from development.microservice_twitch_atlas_formats;";
                        command.ExecuteNonQuery();
                        Log.Info($@"Loading production.microservice_twitch_atlas_formats");
                        command.CommandText = $@"truncate table production.microservice_twitch_atlas_formats;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into production.microservice_twitch_atlas_formats select * from development.microservice_twitch_atlas_formats;";
                        command.ExecuteNonQuery();
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        private void ExecuteSubTopicBackfill()
        {
            var backfill = new List<microservice_twitch_atlas_sub_topics>();
            try
            {
                // Get data from upstream source
                using (var conn = DBManagerRedshift.TahoeConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText =
                        @"
                            select
                                subtopic_id as sub_topic_id,
                                topic_id,
                                subtopic as sub_topic_name,
                                null as sub_topic_description,
                                true as is_active,
                                getdate() as created_time,
                                'BulkImport' as created_user
                            from metadata.atlas_d_subtopic
                            order by sub_topic_id
                            ;
                        ";
                        using (var reader = command.ExecuteReader())
                        {
                            if (reader.HasRows)
                            {
                                while (reader.Read())
                                {
                                    var subTopicID = reader.GetInt32(0);
                                    var topicID = reader.GetInt32(1);
                                    var subtopicName = reader.GetString(2);
                                    var subtopicDescription = reader.GetValue(3);
                                    var isActive = reader.GetBoolean(4);
                                    var createdTime = reader.GetDateTime(5);
                                    var createdUser = reader.GetString(6);
                                    var item = new microservice_twitch_atlas_sub_topics()
                                    {
                                        sub_topic_id = subTopicID,
                                        topic_id = topicID,
                                        sub_topic_name = subtopicName,
                                        sub_topic_description = subtopicDescription == null || subtopicDescription == DBNull.Value
                                            ? null
                                            : (string)subtopicDescription,
                                        is_active = isActive,
                                        created_time = createdTime,
                                        created_user = createdUser,
                                        hash = HashHelper.SimpleRandomLetterSequence.RandomHash()
                                    };
                                    backfill.Add(item);
                                }
                            }
                        }
                    }
                }

                Log.Info($@"Found {backfill.Count()} SubTopic items");

                // Push data to RDS
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText =
                        $@"
                            replace into development.microservice_twitch_atlas_sub_topics
                            (
                                sub_topic_id, topic_id, sub_topic_name, sub_topic_description,
                                is_active, created_time, created_user, hash
                            )
                            select
                                @sub_topic_id, @topic_id, @sub_topic_name, @sub_topic_description,
                                @is_active, @created_time, @created_user, @hash
                            ;
                        ";
                        foreach (var item in backfill)
                        {
                            command.Parameters.Clear();
                            command.Parameters.AddWithValue("@sub_topic_id", item.sub_topic_id);
                            command.Parameters.AddWithValue("@topic_id", item.topic_id);
                            command.Parameters.AddWithValue("@sub_topic_name", item.sub_topic_name);
                            command.Parameters.AddWithValue("@sub_topic_description", item.sub_topic_description);
                            command.Parameters.AddWithValue("@is_active", item.is_active);
                            command.Parameters.AddWithValue("@created_time", item.created_time);
                            command.Parameters.AddWithValue("@created_user", item.created_user);
                            command.Parameters.AddWithValue("@hash", item.hash);
                            command.ExecuteNonQuery();
                        }
                        command.Parameters.Clear();
                        Log.Info($@"Loading staging.microservice_twitch_atlas_sub_topics");
                        command.CommandText = $@"truncate table staging.microservice_twitch_atlas_sub_topics;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into staging.microservice_twitch_atlas_sub_topics select * from development.microservice_twitch_atlas_sub_topics;";
                        command.ExecuteNonQuery();
                        Log.Info($@"Loading production.microservice_twitch_atlas_sub_topics");
                        command.CommandText = $@"truncate table production.microservice_twitch_atlas_sub_topics;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into production.microservice_twitch_atlas_sub_topics select * from development.microservice_twitch_atlas_sub_topics;";
                        command.ExecuteNonQuery();
                    }
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex);
            }
        }

        private void ExecuteTopicBackfill()
        {
            var backfill = new List<microservice_twitch_atlas_topics>();
            try
            {
                // Get data from upstream source
                using (var conn = DBManagerRedshift.TahoeConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandText =
                        @"
                            select
                                topic_id,
                                topic as topic_name,
                                null as topic_description,
                                case when topic ilike '%esports%' then true else false end as is_gaming,
                                true as is_active,
                                getdate() as created_time,
                                'BulkImport' as created_user
                            from metadata.atlas_d_topic
                            order by topic_id
                            ;
                        ";
                        using (var reader = command.ExecuteReader())
                        {
                            if (reader.HasRows)
                            {
                                while (reader.Read())
                                {
                                    var topicID = reader.GetInt32(0);
                                    var topicName = reader.GetString(1);
                                    var topicDescription = reader.GetValue(2);
                                    var isGaming = reader.GetBoolean(3);
                                    var isActive = reader.GetBoolean(4);
                                    var createdTime = reader.GetDateTime(5);
                                    var createdUser = reader.GetString(6);
                                    var item = new microservice_twitch_atlas_topics()
                                    {
                                        topic_id = topicID,
                                        topic_name = topicName,
                                        topic_description = topicDescription == null || topicDescription == DBNull.Value
                                            ? null
                                            : (string)topicDescription,
                                        is_gaming = isGaming,
                                        is_active = isActive,
                                        created_time = createdTime,
                                        created_user = createdUser,
                                        hash = HashHelper.SimpleRandomLetterSequence.RandomHash()
                                    };
                                    backfill.Add(item);
                                }
                            }
                        }
                    }
                }

                Log.Info($@"Found {backfill.Count()} Topic items");

                // Push data to RDS
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        Log.Info($@"Loading development.microservice_twitch_atlas_topics");
                        command.CommandText = $@"truncate table development.microservice_twitch_atlas_topics;";
                        command.ExecuteNonQuery();
                        command.CommandText =
                        $@"
                            replace into development.microservice_twitch_atlas_topics
                            (
                                topic_id, topic_name, topic_description, is_gaming, 
                                is_active, created_time, created_user, hash
                            )
                            select
                                @topic_id, @topic_name, @topic_description, @is_gaming, 
                                @is_active, @created_time, @created_user,@hash
                            ;
                        ";
                        foreach (var item in backfill)
                        {
                            command.Parameters.Clear();
                            command.Parameters.AddWithValue("@topic_id", item.topic_id);
                            command.Parameters.AddWithValue("@topic_name", item.topic_name);
                            command.Parameters.AddWithValue("@topic_description", item.topic_description);
                            command.Parameters.AddWithValue("@is_gaming", item.is_gaming);
                            command.Parameters.AddWithValue("@is_active", item.is_active);
                            command.Parameters.AddWithValue("@created_time", item.created_time);
                            command.Parameters.AddWithValue("@created_user", item.created_user);
                            command.Parameters.AddWithValue("@hash", item.hash);
                            command.ExecuteNonQuery();
                        }
                        command.Parameters.Clear();
                        Log.Info($@"Loading staging.microservice_twitch_atlas_topics");
                        command.CommandText = $@"truncate table staging.microservice_twitch_atlas_topics;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into staging.microservice_twitch_atlas_topics select * from development.microservice_twitch_atlas_topics;";
                        command.ExecuteNonQuery();
                        Log.Info($@"Loading production.microservice_twitch_atlas_topics");
                        command.CommandText = $@"truncate table production.microservice_twitch_atlas_topics;";
                        command.ExecuteNonQuery();
                        command.CommandText = $@"insert into production.microservice_twitch_atlas_topics select * from development.microservice_twitch_atlas_topics;";
                        command.ExecuteNonQuery();
                    }
                }
            }
            catch(Exception ex)
            {
                Log.Error(ex);
            }
        }

        
        private void ExecuteLDAPBackfill()
        {
            Log.Info("Starting Account Manager Backfill");
            using (var conn = DBManagerMysql.GetConnection(true))
            {
                using (var command = conn.GetCommand())
                {
                    Log.Info($@"Loading staging.microservice_twitch_atlas_account_manager");
                    command.CommandText = $@"truncate table staging.microservice_twitch_atlas_account_manager;";
                    command.ExecuteNonQuery();
                    command.CommandText = $@"insert into staging.microservice_twitch_atlas_account_manager select * from development.microservice_twitch_atlas_account_manager;";
                    command.ExecuteNonQuery();
                    Log.Info($@"Loading production.microservice_twitch_atlas_account_manager");
                    command.CommandText = $@"truncate table production.microservice_twitch_atlas_account_manager;";
                    command.ExecuteNonQuery();
                    command.CommandText = $@"insert into production.microservice_twitch_atlas_account_manager select * from development.microservice_twitch_atlas_account_manager;";
                    command.ExecuteNonQuery();
                }
            }
        }
    }
}
*/