﻿using Resonance.Core;
using Resonance.Core.Helpers.AwsHelpers;
using Resonance.Core.Helpers.DatabaseHelpers;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models;
using Resonance.Core.Models.ConfigurationModels.Jobs;
using Resonance.Jobs.Amp;
using Resonance.Microservices.Queries;
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace Resonance.Jobs.Atlas.DataPopulation
{
    public class GameSyncJob : JobBase, IJob<long>
    {
        public GameSyncJob(JobConfiguration _config)
        {
            try
            {
                Config = _config;
                Log.Info($@"GameSyncJob: configured. IsActive: {Config.IsActive}");
            }
            catch (Exception)
            {

            }
        }

        public override void Run()
        {
            try
            {
                List<string> gameNames = new List<string>();
                using (var tahoeConn = DBManagerRedshift.TahoeConnection())
                {
                    using (var command = tahoeConn.CreateCommand())
                    {
                        command.CommandText = "select name from warehouse.dim_game";
                        using (var reader = new DataReaderWithMeasurements(command, null, "get_twitch_games").NpgReader)
                        {
                            while (reader.Read())
                            {
                                string gameName = (string)reader["name"];
                                gameNames.Add(gameName);
                            }
                        }
                    }
                }
                using (var conn = DBManagerMysql.GetConnection())
                {
                    using (var command = conn.CreateCommand())
                    {
                        command.CommandText = $"truncate table {Constants.DatabaseSchema}microservice_twitch_atlas_game_names";
                        command.ExecuteNonQueryWithMeasurements("game_sync_cleanup");
                        command.CommandText = $"insert into {Constants.DatabaseSchema}microservice_twitch_atlas_game_names (game_name) values(@game_name)";
                        foreach (string gameName in gameNames)
                        {
                            command.Parameters.Clear();
                            command.Parameters.AddWithValue("@game_name", gameName);
                            command.ExecuteNonQueryWithMeasurements("update_game_sync");
                        }
                    }
                }
                /*
                string tempFile = Path.GetTempFileName();
                File.WriteAllLines(tempFile, gameNames);
                string s3Bucket = ConstantsWorker.WorkerS3Bucket;
                string s3Path = $"atlas-games";
                using (FileStream fileStream = File.OpenRead(tempFile))
                {
                    S3Helper.UploadToS3(fileStream, s3Bucket, s3Path);
                }

                DBManagerMysql.ImportToMysqlFromS3
                    (
                        prefixQuery: new MySql.Data.MySqlClient.MySqlCommand($"truncate table {Constants.DatabaseSchema}microservice_twitch_atlas_game_names"),
                        primaryQuery: AmpQuerySql.LoadFileFromS3(s3Bucket, s3Path, @"microservice_twitch_atlas_game_names"),
                        timeout: 86400
                    );
                    */
            }
            finally
            {
                Log.Info("Game Sync Done");
                this.Config.IsRunning = false;
                this.Config.NextRunTime = DateTime.UtcNow.Add(TimeSpan.FromDays(1));
            }
        }
    }
}
