﻿using Resonance.Core;
using Resonance.Core.Helpers.AwsHelpers;
using Resonance.Core.Helpers.DatabaseHelpers;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Helpers.StatsDHelpers;
using Resonance.Jobs.Amp;
using System;
using System.Threading;

namespace Resonance.Jobs.Atlas
{
    class Program
    {
        internal static EventWaitHandle QuitHandle = new EventWaitHandle(false, EventResetMode.AutoReset, "quit-trigger");
        internal static EventWaitHandle GracefulQuitHandle = new EventWaitHandle(false, EventResetMode.AutoReset, "graceful-quit-trigger");

        static void Main(string[] args)
        {
            try
            {
                AppConfig.Initialize(ref args);

                Console.Title = ($@"Resonance Atlas Jobs ({AppConfig.Data.Application.Environment})");
                Constants.InitConstants(AppConfig.Data, "AtlasJobs");
                Log.Initialize();
                CloudwatchHelper.Initialize("Jobs.Atlas");
                string ip = "telegraf.cursedata.io";
                StatsDHelper.Initialize(AppConfig.Data.Application.BaseCloudwatchLogPath, ip, 8125, "Resonance", $"AmpJobs", TimeSpan.FromMinutes(1));

                DBManagerMysql.Initialize("atlas");

                JobManager.Initialize();

                CommandManager.Initialize();
                GracefulQuitHandle.WaitOne();
                QuitHandle.WaitOne();
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                Log.Error(ex);
            }
            finally
            {
                Log.Info("Jobs is shutting down");
                NLog.LogManager.Shutdown();
            }
        }
    }
}
