﻿using Microsoft.Extensions.Configuration;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models.ConfigurationModels;
using System.Collections.Generic;
using System.IO;

namespace Resonance.JustTesting
{
    internal static class AppConfig
    {
        internal static IConfigurationRoot Configuration { get; private set; }
        internal static ApplicationConfigurationModel Data { get; private set; }

        internal static void Initialize(ref string[] args)
        {
            var builder = new ConfigurationBuilder();
            builder.AddCommandLine(args);
            var config = builder.Build();

            Configuration = new ConfigurationBuilder()
                .SetBasePath(Directory.GetCurrentDirectory())
                .AddJsonFile($"appsettings.{config["environment"]}.json", optional: false, reloadOnChange: true)
                .Build();

            Data = Configuration.GetSection("Resonance").Get<ApplicationConfigurationModel>();
        }
    }
}
