﻿using MySql.Data.MySqlClient;
using Newtonsoft.Json;
using Resonance.Core;
using Resonance.Core.Helpers;
using Resonance.Core.Helpers.ApiHelpers;
using Resonance.Core.Helpers.AwsHelpers;
using Resonance.Core.Helpers.ConfigurationHelpers;
using Resonance.Core.Helpers.DatabaseHelpers;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Helpers.StatsDHelpers;
using Resonance.Core.Models.ApiModels;
using Resonance.Core.Models.AuthModels;
using Resonance.Core.Models.ConfigurationModels.Permissions;
using Resonance.Core.Models.ConfigurationModels.Salesforce;
using Resonance.Core.Models.DatabaseModels.RedshiftModels;
using Resonance.Core.Models.DatabaseModels.RequestModels;
using Resonance.Core.Services.ColumnFilterService;
using Resonance.Core.Services.CustomConfigService;
using Resonance.Jobs.Amp;
using Resonance.Jobs.Atlas.ContractAutoExtender.Methods;
using Resonance.Jobs.Atlas.ContractAutoExtender.Query;
using Resonance.Jobs.Atlas.Contracts;
using Resonance.Microservices.Methods;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net;
using System.Threading;
using System.Threading.Tasks;
using static Resonance.Core.Models.FilterModels.CustomTwitchDirectFilters;
using Amazon.Lambda.APIGatewayEvents;
using Amazon.Lambda.Model;
using Amazon;
using System.Diagnostics;
using Amazon.Runtime.CredentialManagement;
using Amazon.SecurityToken;
using Amazon.SecurityToken.Model;
using Amazon.Runtime;

namespace Resonance.JustTesting
{
    class Program
    {
        private static EventWaitHandle quitTrigger = new EventWaitHandle(false, EventResetMode.AutoReset);
        static void Main(string[] args)
        {
            AppConfig.Initialize(ref args);
            Constants.InitConstants(AppConfig.Data, "JustTesting");
            CloudwatchHelper.Initialize("Test.JustTesting");
            string ip = "telegraf.cursedata.io";
            StatsDHelper.Initialize(AppConfig.Data.Application.BaseCloudwatchLogPath, ip, 8125, "Resonance", $"JustTesting", TimeSpan.FromMinutes(1));
            Log.Initialize();
            DBManagerMysql.Initialize("resonance");

            // BEGIN FULTON DEMO

            // Get the profile specified in the '~/.aws' credentials file called 'fulton_tmb_sandbox_bridge_profile'
            // This profile is special, in that it is a role created on account 017821106956 for the Fulton TMB Sandbox account
            // This specified role has a trust relationship to our main account 029773783190 to allow role assumption.
            // If you are using a role to manage permissions instead of a user for the trusted role on the target account
            // You will need to do a two-step hop, credentials for the allowed role, then credentials for the target arn
            var credentials = STSHelper.GetCredentials("fulton_tmb_sandbox_bridge_profile");
           
            // Definition for the actual request sent to the lambda, this calls a twirp example method with the defined body
            APIGatewayProxyRequest proxyRequest = new APIGatewayProxyRequest()
            {
                HttpMethod = "POST",
                IsBase64Encoded = false,
                Path = "/twirp/twitch.fulton.example.fultontmbsandbox.FultonTMBSandbox/GetPrice",
                Headers = new Dictionary<string, string>() { { "Content-Type", "application/json" } },
                Body = "{\"vegetable\":\"test\"}"
            };

            // Create a lambda client using the assumed role credentials
            Amazon.Lambda.AmazonLambdaClient lambdaClient = new Amazon.Lambda.AmazonLambdaClient(credentials, RegionEndpoint.USWest2);

            var invokeRequest = new InvokeRequest()
            {
                FunctionName = "arn:aws:lambda:us-west-2:017821106956:function:FultonTMBSandbox-LambdaFunction-1NS4P7UA7QH6A:live",
                Payload = JsonConvert.SerializeObject(proxyRequest)
                
            };
            try
            {
                var ia = lambdaClient.InvokeAsync(invokeRequest);
                ia.Wait();
                var lambdaResponse = ia.Result;
                using (TextReader reader = new StreamReader(lambdaResponse.Payload))
                {
                    var rdr = reader.ReadToEndAsync();
                    rdr.Wait();
                    string lambdaResponseString = rdr.Result;
                    APIGatewayProxyResponse response = JsonConvert.DeserializeObject<APIGatewayProxyResponse>(lambdaResponseString);
                    dynamic results = JsonConvert.DeserializeObject<dynamic>(response.Body);
                    Console.WriteLine(response.Body);
                }
            }
            catch(Exception ex)
            {
                Console.WriteLine(ex);
            }
            // END FULTON DEMO
            
            //AmpMethods ampMethods = new AmpMethods();
            //ampMethods.RecalcSortOrders("5bb1c6e6-c619-4cc3-963b-9885867624d0");
            //SetManualPriorities();
            /*ManuallyAddChannelToSalesforce("9d169271-baed-4742-9fd7-bde27992862d", new[] {
                new RequestChannel() { ChannelID = 37047104, ChannelLogin = "incon", Priority = 1  } });
            */
            /*ManuallyAddChannelToSalesforce("00152961-4593-4d47-8530-a7aa67cab930", new[] { 
                new RequestChannel() { ChannelID = 3481156, ChannelLogin = "valkia", Priority = 1  }, 
                new RequestChannel() { ChannelID = 51584204, ChannelLogin = "twosixnine", Priority = 4 }, 
                new RequestChannel() { ChannelID = 101337422, ChannelLogin = "mavricplays", Priority = 5 }, 
                //new RequestChannel() { ChannelID = 63142572, ChannelLogin = "cyanideplaysgames", Priority = 6 },
                new RequestChannel() { ChannelID = 56964879, ChannelLogin = "twoangrygamerstv", Priority = 9 },
                    new RequestChannel() { ChannelID = 66076836, ChannelLogin = "stewie2k", Priority = 6 }
                }
            );
            */
            //SetManualPriorities();
            //SetupNewAtlasRolesAndPermsForViewers();
            //ampMethods.SubmitRequest("5bb1c6e6-c619-4cc3-963b-9885867624d0", new AuthTokenData() { User = "paraashl" });
            //RequestDetails requestDetails = ampMethods.GetRequest(@"6f088b44-e95e-4b9c-9a49-b42776022fc1");
            //ampMethods.FinalizeRequest(@"6f088b44-e95e-4b9c-9a49-b42776022fc1", new AuthTokenData() { User = "paraashl" }, new Core.Models.ApiModels.RequestModels.FinalizeRequest() { Channels = requestDetails.Channels });

            //AddAtlasAdmin(new[] { "kdoner", "jesell", "jpaine", "gvialle", "zinanmei", "cknapp", "mggargan", "carapardee", "bvallat" });
            //AddAmpApprover("chrikels");
            //AddAmpApprover("jssicwe");
            //AddAmpApprover("fuelison");
            //AddAmpApprover("almeidw");
            //AddAmpApprover("cacarl");
            //SetAmpServiceToken("b6b427af-43e5-42bf-8cda-app-service");
            //AmpMethods methods = new AmpMethods();
            //methods.RecalcSortOrders("49e40b2b-c854-4a7e-934b-f2af5ef91a89");
            //AddAmpApprover("zhichew");
            //UpdateSalesforceExpectedParticipants();
            //return;
            //MigrateServiceToken();
            //S3Helper.WriteStringToS3(File.ReadAllText(@"C:\Users\wqqnsinkule\Downloads\atlas-service (1).json\atlas-service (1).json"), "resonance-configuration", $"{Constants.AppConfig.Application.Environment}/credentials/resonance/oauth/atlas-service.json.gz", true);
            Console.WriteLine("Done");
            quitTrigger.WaitOne();
            return;
            AuthTokenData tokens = new AuthTokenData();
            tokens.User = "bmussa";

            //methods.SubmitRequest("96fe9588-2939-418f-8bcc-5fee3df8e9b4", tokens);
            //return;

            //methods.SubmitRequest("790714e7-b062-4870-8cdc-ce72c04690de", tokens);
            //return;

            //ColumnFilterService service = new ColumnFilterService();
            //service.GetRemoveColumnList(new List<string>(new[] {  "General Access"}));

            //FilterOptionsHelper helper = new FilterOptionsHelper();
            //helper.CreateFiles(new CustomConfigService(@"Development/custom-configuration/"));
            //helper.CreateFiles(new CustomConfigService(@"Staging/custom-configuration/"));
            //helper.CreateFiles(new CustomConfigService(@"Production/custom-configuration/"));
            //return;
            PermissionHelper permHelper = new PermissionHelper();
            var permissions = permHelper.GetPermissionsFromS3("Amp"); // Load permissions from the Amp project

            //string guid = Guid.NewGuid().ToString();
            //TokenModel apiToken = new TokenModel() { TokenID = guid, TokenDescription = "Allows amazon access to amp data", TokenName = guid + "-amazon" };
            //permissions.Tokens.Add(apiToken);
            //permissions.RoleToTokenMap["TwitchUserListing"].Add(apiToken.TokenName);
            //permHelper.WritePermissionsToS3(permissions);
            //return;
            //bool exists = permissions.LdapNames.Any(x => x.LdapName == "foroudih");
            //Console.WriteLine("exists: " + exists);
            //return;
            //permissions.RoleToLdapNameMap.Add("RequestViewer", new List<string>());
            //permissions.RoleToLdapNameMap.Add("AmpDev", new List<string>());
            /*foreach(var map in permissions.RoleToPermissionMap)
            {
                map.Value.Remove("Can See Revenue Data");
            }*/
            /*using (MySqlConnection conn = DBManagerMysql.GetConnection())
            {
                using (MySqlCommand command = conn.CreateCommand())
                {
                    command.CommandText = "select distinct(AccountManager) from production.microservice_twitch_user_listing_past_360_days where AccountManager is not null and AccountManager != ''";
                    using (MySqlDataReader reader = command.ExecuteReader())
                    {
                    */
            foreach (string ldap in new[] { "wilmork" })
            //while(reader.Read())
            {
                //string ldap = (string)reader[0];
                string ldapID = Guid.NewGuid().ToString();
                permissions.LdapNames.Add(new Core.Models.ConfigurationModels.Permissions.LdapNameModel() { LdapName = ldap, LdapNameDescription = ldap, LdapNameID = ldapID });
                permissions.RoleToLdapNameMap["RequestApprover"].Add(ldap);
            }
            /*
        }
    }
}
*/
            /*
            permissions.RoleToLdapNameMap["AmpDev"].Add("nsinkule");
            permissions.Roles.Add(new Core.Models.ConfigurationModels.Permissions.RoleModel() { RoleID = Guid.NewGuid().ToString(), RoleName = "AmpDev", RoleDescription = "Allows amp developers to test live functionality" });
            */
            //permissions.Roles.Add(new Core.Models.ConfigurationModels.Permissions.RoleModel() { RoleID = Guid.NewGuid().ToString(), RoleName = "RequestViewer", RoleDescription = "Allows partnership members to view all submitted requests" });
            //string allowAllGroup = Guid.NewGuid().ToString().ToLower();
            //permissions.LdapGroups.Add(new Core.Models.ConfigurationModels.Permissions.LdapGroupModel() { LdapGroupName = "*", LdapGroupDescription = "", LdapGroupId = allowAllGroup });
            //permissions.RoleToLdapGroupMap["TwitchUserListing"].Add("*");
            //permissions.RoleToPermissionMap.Add("RequestViewer", new[] { ConstantsPermissions.Amp.CanSeeAllRequests }.ToList());
            //permissions.RoleToPermissionMap.Add("RequestApprover", permissions.RoleToPermissionMap["TwitchUserListing"].ToArray().ToList());
            //permissions.RoleToPermissionMap["TwitchUserListing"].Remove("Can Approve Requests");
            //permHelper.WritePermissionsToS3(permissions);
            return;
            //StatsDHelper.Initialize(AppConfig.Data.Application.BaseCloudwatchLogPath, ip, 8125, "Resonance", $"Auth", TimeSpan.FromMinutes(1));            
            //DBManagerMysql.Initialize();

            //FilterOptionsHelper helper = new FilterOptionsHelper();
            //helper.CreateFiles(new CustomConfigService(@"Production/custom-configuration/"));
            //helper.CreateFiles(new CustomConfigService(@"Staging/custom-configuration/"));
            //helper.CreateFiles(new CustomConfigService(@"Production/custom-configuration/"));
            //return;

            ColumnFilterService svc = new ColumnFilterService();

            string[] roles = new string[] { "TwitchUserListing" };
            string[] columns = new string[] {
                    "channelid",
                    "login",
                    "channelconcurrentsminuteswatchedtotal",
                    "channelconcurrentsminutesbroadcasttotal",
                    "maxccu",
                    "averageccu",
                    "followercounttotal",
                    "uniquedaysbroadcast",
                    "topgamebroadcast",
                    "minuteswatcheddata",
                    "averageccudata",
                    "profileimage",
                    "subssoldtotal",
                    "substotal" };
            //svc.GetRestrictedColumnsByRoles(roles);
        }

        public static void TestRequests()
        {
            object title = new object();
            int successCounter = 0;
            int failCounter = 0;
            Parallel.For(0, 1000,new ParallelOptions() { MaxDegreeOfParallelism = 32 } ,(x,y) =>
            {
                WebClient client = new WebClient();
                client.Headers.Add("Content-Type", "application/json");
                client.Headers.Add("Authorization", "Bearer eyJhbGciOiJodHRwOi8vd3d3LnczLm9yZy8yMDAxLzA0L3htbGRzaWctbW9yZSNobWFjLXNoYTI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VyIjoibnNpbmt1bGUiLCJleHBpcmVzIjoiMjAxOS0wNi0xNVQyMToxNDozNy4zODM5OTE3WiIsImVtYWlsIjoibnNpbmt1bGVAdHdpdGNoLnR2IiwiZ3JvdXBzIjpbImdpdCIsImFwcC1keW5hbWljLXRlc3QiLCJ2cG4tYWNjZXNzIiwidnBuLXNmby1hY2Nlc3MiLCJwdy1yZXNldC1lbmFibGVkIl19.9c-IHtaXzaLC01ZwdOFk76VMCNxt0ZpbCK3oR9qleJA");
                try
                {
                    string response = client.UploadString(@"http://172.29.3.110:8083/worker/amp/get-twitch-user-listing", "POST", "{\"limit\":12,\"page\":0,\"aggtype\":30,\"req-cols\":[\"channelid\",\"login\",\"channelconcurrentsminuteswatchedtotal\",\"channelconcurrentsminutesbroadcasttotal\",\"maxccu\",\"averageccu\",\"followercounttotal\",\"uniquedaysbroadcast\",\"topgamebroadcast\",\"minuteswatcheddata\",\"averageccudata\",\"profileimage\",\"subssoldtotal\",\"substotal\"],\"filters\":[],\"sortdata\":[{\"col\":\"channelconcurrentsminuteswatchedtotal\",\"ord\":0,\"asc\":false}]}");
                    dynamic responseData = JsonConvert.DeserializeObject<dynamic>(response);
                    bool success = responseData.success;
                    if (success)
                    {
                        Interlocked.Increment(ref successCounter);
                    }
                    else
                    {
                        Interlocked.Increment(ref failCounter);
                    }
                }
                catch(Exception)
                {
                    Interlocked.Increment(ref failCounter);
                }
                lock(title)
                {
                    Console.Title = "Success: " + successCounter + " Fails: " + failCounter;
                }
                return;
            });
            lock (title)
            {
                Console.Title = "Success: " + successCounter + " Fails: " + failCounter;
            }

            string end = Console.ReadLine();
        }

        public static void ExportToMysql(string[] args)
        {
            throw new NotImplementedException();
            /*
            AppConfig.Initialize(ref args);

            Console.Title = ($@"Resonance Jobs ({AppConfig.Data.Application.Environment})");
            Constants.InitConstants(AppConfig.Data, "Jobs");
            Log.Initialize();
            string ip = "telegraf.cursedata.io";
            StatsDHelper.Initialize(AppConfig.Data.Application.BaseCloudwatchLogPath, ip, 8125, "Resonance", $"Jobs", TimeSpan.FromMinutes(1));

            DBManagerMysql.Initialize();
            string data = "";
            var folderpath = $"{Constants.AppConfig.Application.Environment}/unload/amp/mysql-twitch-user-listing/2019/06/06/30/";
            AmpMethods method = new AmpMethods();
            method.Initialize();
            var postdata = new ManifestModel()
            {
                AggregationType = Constants.AggregationType.ThirtyDay,
                Bucket = folderpath,
                ManifestFiles = new List<string>()
                                        {
                                            folderpath
                                        }
            };
            var response = new ApiListResponse<EmptyModel>()
            {
                RequestStartTime = DateTime.UtcNow,
                WorkerIdentifier = ConstantsWorker.WorkerIdentifier
            };
            UserListingMysqlImport.ProcessImport(postdata, method, response);
        */
        }

        public static void SetupNewAtlasRolesAndPermsForViewers()
        {
            PermissionHelper permHelper = new PermissionHelper();
            var permissions = permHelper.GetPermissionsFromS3("Atlas");
            var ampPermissions = permHelper.GetPermissionsFromS3("Amp");
            permissions.RoleToPermissionMap["AccountManagers"].Add(ConstantsPermissions.Atlas.CanViewAnyContract);
            permissions.RoleToPermissionMap["ProductManager"].Add(ConstantsPermissions.Atlas.CanViewAnyContract);

            permissions.Roles.Add(new RoleModel() { RoleID = Guid.NewGuid().ToString(), RoleName = "Viewer", RoleDescription = "Allows for normal users to view all atlas data except contracts" });
            permissions.RoleToPermissionMap.Add("Viewer", new List<string>(new[] { ConstantsPermissions.Atlas.GeneralAccess }));
            permissions.RoleToLdapGroupMap.Add("Viewer", new List<string>(new[] { "*" }));

            permHelper.WritePermissionsToS3("Atlas", permissions);
        }

        public static void UpdateSalesforceExpectedParticipants()
        {
            using (var conn = DBManagerMysql.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    command.CommandText = "select request_id, participant_count from production.microservice_twitch_request";
                    using (var reader = new DataReaderWithMeasurements(command, null, "get_salesforce_expected_participants").MysqlReader)
                    {
                        while (reader.Read())
                        {
                            string requestID = reader.GetString(0);
                            int participantCount = reader.GetInt32(1);
                            SalesforceHelpers.UpdateRecordByExternalID("AMP_Request__c", "AMP_ID__c", requestID, new { Number_Expected__c = participantCount });
                        }
                    }
                }
            }
        }

        public static void SetAmpServiceToken(string token)
        {
            PermissionHelper permHelper = new PermissionHelper();
            var amppermissions = permHelper.GetPermissionsFromS3("Amp");
            amppermissions.RoleToTokenMap["TwitchUserListing"].Add(token);
            permHelper.WritePermissionsToS3("Amp", amppermissions);
        }

        public static void MigrateServiceToken()
        {
            PermissionHelper permHelper = new PermissionHelper();
            var permissions = permHelper.GetPermissionsFromS3("Atlas");
            var amppermissions = permHelper.GetPermissionsFromS3("Amp");
            amppermissions.RoleToPermissionMap.Add("AppServiceToken", new List<string>(new[] { "General Access" }) );

            string newToken = amppermissions.RoleToTokenMap["AppServiceToken"].First();
            permissions.Tokens.Add(new TokenModel() { TokenID = newToken, TokenName = "ServiceToken", TokenDescription = "Token used for services to communicate with each other directly" });
            permissions.RoleToTokenMap.Add("AppServiceToken", new[] { newToken }.ToList());
            permissions.RoleToTokenMap.Remove(newToken);
            permissions.RoleToPermissionMap.Add("AppServiceToken", new List<string>(new[] { "General Access" }));

            permHelper.WritePermissionsToS3("Amp", amppermissions);
            permHelper.WritePermissionsToS3("Atlas", permissions);
        }

        public static void AddAtlasAdmin(IEnumerable<string> ldaps)
        {
            PermissionHelper permHelper = new PermissionHelper();
            var permissions = permHelper.GetPermissionsFromS3("Atlas");
            foreach (string ldap in ldaps)
            {

                string ldapID = Guid.NewGuid().ToString();

                permissions.LdapNames.Add(new Core.Models.ConfigurationModels.Permissions.LdapNameModel() { LdapName = ldap, LdapNameDescription = ldap, LdapNameID = ldapID });
                if(!permissions.RoleToLdapNameMap.ContainsKey("ProductManager"))
                {
                    permissions.RoleToLdapNameMap.Add("ProductManager", new List<string>());
                }

                permissions.RoleToLdapNameMap["ProductManager"].Add(ldap);
            }
            permHelper.WritePermissionsToS3("Atlas", permissions);
        }

        public static void ConfigureAtlasAMRole()
        {
            PermissionHelper permHelper = new PermissionHelper();
            var permissions = permHelper.GetPermissionsFromS3("Atlas");
            /*foreach(var perm in permissions.Permissions)
            {
                if(perm.PermissionName == "ManageOwnedChannels")
                {
                    perm.PermissionName = "Manage Owned Channels";
                }
            }
            foreach(var permMap in permissions.RoleToPermissionMap)
            {
                if(permMap.Key == "AccountManagers")
                {
                    permMap.Value.Remove("ManageOwnedChannels");
                    permMap.Value.Add("Manage Owned Channels");
                }
            }*/
            permissions.RoleToLdapNameMap.Remove("ProductManager");
            permHelper.WritePermissionsToS3("Atlas", permissions);
        }

        public static void MigrateAtlasRoles()
        {
            PermissionHelper permHelper = new PermissionHelper();
            var permissions = permHelper.GetPermissionsFromS3("Atlas"); // Load permissions from the Amp project
            var amppermissions = permHelper.GetPermissionsFromS3("Amp"); // Load permissions from the Amp project
                                                                         // permissions.Roles.Add(new RoleModel() { RoleID = Guid.NewGuid().ToString(), RoleName = "ProductManager", RoleDescription = "" });
                                                                         //permissions.RoleToPermissionMap.Add("ProductManager", new[] { "ManageOwnedChannels", "General Access" }.ToList());
            permissions.RoleToPermissionMap["ProductManager"].Add("Can View Product Assets");
            permissions.RoleToPermissionMap["ProductManager"].Add("Can Manage Products");
            
            /*permissions.Permissions.Add(new PermissionModel() { PermissionID = Guid.NewGuid().ToString(), PermissionName = "ManageOwnedChannels", PermissionDescription = "Allows managing channels owned as an account manager" });
            permissions.Roles.Add(new RoleModel() { RoleID = Guid.NewGuid().ToString(), RoleName = "AccountManagers", RoleDescription = "" });
            permissions.RoleToPermissionMap.Add("AccountManagers", new[] { "ManageOwnedChannels", "General Access" }.ToList());
            permissions.RoleToLdapGroupMap.Add("AccountManagers", new[] { "atlas-account-managers" }.ToList());
            permissions.RoleToLdapGroupMap["ProductManager"] = new[] { "atlas-admins" }.ToList();

            permissions.LdapGroups = new[] { new LdapGroupModel() { LdapGroupId = Guid.NewGuid().ToString(), LdapGroupName = "atlas-admins", LdapGroupDescription = "Atlas Admins" }, new LdapGroupModel() { LdapGroupId = Guid.NewGuid().ToString(), LdapGroupName = "atlas-account-managers", LdapGroupDescription = "Atlas Account Managers" } }.ToList();
            */

            permHelper.WritePermissionsToS3("Atlas", permissions);
        }

        public static void FixRequests()
        {
            AmpMethods methods = new AmpMethods();
            Dictionary<string, Dictionary<int, int>> requestChannelLookup = new Dictionary<string, Dictionary<int, int>>();
            string[] lines = File.ReadAllLines(@"C:\test\new_request_priorities.csv");
            using (var conn = DBManagerMysql.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    foreach (string line in lines)
                    {
                        string[] lineParts = line.Split(',');
                        string requestID = lineParts[0];
                        string channelName = lineParts[1];
                        int priority = int.Parse(lineParts[2]);
                        if (!requestChannelLookup.ContainsKey(requestID))
                        {
                            requestChannelLookup.Add(requestID, new Dictionary<int, int>());
                        }
                        try
                        {
                            command.Parameters.Clear();
                            command.Parameters.AddWithValue("@request_id", requestID);
                            command.Parameters.AddWithValue("@login", channelName);
                            command.CommandText = "select channel_id from production.microservice_twitch_request_channel where request_id = @request_id and channel_login = @login";

                            int channelID = (int)command.ExecuteScalar();
                            requestChannelLookup[requestID].Add(channelID, priority);
                        }
                        catch (Exception)
                        {

                        }
                        
                    }
                }
                foreach(var requestEntry in requestChannelLookup)
                {
                    string requestID = requestEntry.Key;
                    var request = methods.GetRequest(requestID);
                    foreach(var channel in request.Channels)
                    {
                        if(!requestEntry.Value.ContainsKey(channel.ChannelID))
                        {
                            var response = SalesforceHelpers.UpdateRecordByExternalID("AMP_Request_Participant__c", "AMP_ID__c", $"{requestID}_{channel.ChannelID}", new { Group__c = 99, Sort_Order__c = 99 });
                        }
                    }
                }
            }
        }

        public static void ImportChannelList()
        {
            string requestID = "8b965c99-7d54-4fb6-9a92-8231422ea294";
            string[] lines = File.ReadAllLines(@"C:\test\amp_z_channels.csv");
            using (var conn = DBManagerMysql.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    foreach (string line in lines)
                    {
                        string[] lineParts = line.Split(',');
                        int channelID = int.Parse(lineParts[0]);
                        command.Parameters.Clear();
                        command.CommandText = "select Login, ProfileImage from production.microservice_twitch_user_details where channelid = @channelid";
                        command.Parameters.AddWithValue("channelid", channelID);
                        string login = "";
                        string profileImage = "";
                        using (var reader = new DataReaderWithMeasurements(command, null, "get_profile_image").MysqlReader)
                        {
                            if (reader.Read())
                            {
                                login = (string)reader["Login"];
                                profileImage = (string)reader["ProfileImage"];

                            }
                        }
                        command.CommandText = "insert into production.microservice_twitch_request_channel (request_id,channel_id, channel_login, profile_image, status) values(@request_id, @channelid, @channel_login,@profile_image, 'manual')";
                        command.Parameters.AddWithValue("request_id", requestID);
                        command.Parameters.AddWithValue("channel_login", login);
                        command.Parameters.AddWithValue("profile_image", profileImage);
                        command.ExecuteNonQueryWithMeasurements("jt_import_channel_list");
                    }
                }
            }
        }

        public static void ManuallyAddChannelToSalesforce(string requestID, IEnumerable<RequestChannel> channels)
        {
            using (var conn = DBManagerMysql.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    foreach (var channel in channels)
                    {
                        command.Parameters.Clear();
                        command.CommandText = @"insert into production.microservice_twitch_request_channel (request_id, channel_id, channel_login, status, Priority, profile_image) values(@request_id, @channel_id, @channel_login, 'Manual', @priority, '')";
                        command.Parameters.AddWithValue("request_id", requestID);
                        command.Parameters.AddWithValue("channel_id", channel.ChannelID);
                        command.Parameters.AddWithValue("channel_login", channel.ChannelLogin);
                        command.Parameters.AddWithValue("priority", channel.Priority);
                        command.ExecuteNonQueryWithMeasurements("jt_manually_add_to_salesforce");
                    }
                }
            }
            
                var batchPayload = new
                {
                    records = channels.Select(channel =>
                    new
                    {
                        attributes = new { type = "AMP_Request_Participant_Payload__c", referenceId = $"{requestID}_{channel.ChannelID}" },
                        AMP_ID__c = $"{requestID}_{channel.ChannelID}",
                        AMP_Request_ID__c = requestID,
                        Channel_ID__c = channel.ChannelID,
                        Channel_Name__c = channel.ChannelLogin,
                        Sort_Order__c = channel.Priority,
                        Group__c = channel.Priority
                    }
                )
                };
            var batchResponse = SalesforceHelpers.PostData("/services/data/v45.0/composite/tree/AMP_Request_Participant_Payload__c", batchPayload);
            if (batchResponse == null)
            {
                throw new Exception("Error Saving Salesforce Participants");
            }

        }

        public static void SetManualPriorities()
        {
            Dictionary<string, HashSet<string>> seenChannels = new Dictionary<string, HashSet<string>>();
            Dictionary<string, int> lastPriorityLookup = new Dictionary<string, int>();
            string[] lines = File.ReadAllLines(@"C:\test\manual_priorities_7_8.txt");
            using (var conn = DBManagerMysql.GetConnection())
            {
                using (var command = conn.CreateCommand())
                {
                    foreach(string line in lines)
                    {
                        string[] lineParts = line.Split(',');
                        string requestID = lineParts[0];
                        string channelName = lineParts[1];
                        int priority = int.Parse(lineParts[2]);
                        if(!seenChannels.ContainsKey(requestID))
                        {
                            seenChannels.Add(requestID, new HashSet<string>());
                        }
                        string existingID = "";
                        if(lineParts.Length >= 4)
                        {
                            existingID = lineParts[3];
                        }
                        seenChannels[requestID].Add(channelName);
                        command.Parameters.Clear();
                        command.CommandText = "update production.microservice_twitch_request_channel set Priority = @priority where request_id = @request_id and channel_login = @login";
                        command.Parameters.AddWithValue("@priority", priority);
                        command.Parameters.AddWithValue("@request_id", requestID);
                        command.Parameters.AddWithValue("@login", channelName);
                        command.ExecuteNonQueryWithMeasurements("jt_set_manual_priorities");
                        if(!lastPriorityLookup.ContainsKey(requestID))
                        {
                            lastPriorityLookup.Add(requestID, 0);
                        }
                        if(priority > lastPriorityLookup[requestID])
                        {
                            lastPriorityLookup[requestID] = priority;
                        }

                        command.CommandText = "select channel_id from production.microservice_twitch_request_channel where request_id = @request_id and channel_login = @login";
                        try
                        {
                            int channelID = (int)command.ExecuteScalar();

                            if(existingID != "")
                            {
                                var response = SalesforceHelpers.UpdateRecord("AMP_Request_Participant__c", existingID, new { Group__c = priority, Sort_Order__c = priority });
                            }
                            else
                            {
                                var response = SalesforceHelpers.UpdateRecordByExternalID("AMP_Request_Participant__c", "AMP_ID__c", $"{requestID}_{channelID}", new { Group__c = priority, Sort_Order__c = priority });
                            }
                        }    
                            
                        catch(Exception)
                        {

                        }
                    }
                    /*
                    foreach(var request in seenChannels)
                    {
                        string requestID = request.Key;
                        int nextPriority = lastPriorityLookup[requestID];
                        command.Parameters.Clear();
                        command.CommandText = "select channel_login from production.microservice_twitch_request_channel where request_id = @request_id";
                        command.Parameters.AddWithValue("request_id", requestID);
                        using (var reader = command.ExecuteReader())
                        {
                            while(reader.Read())
                            {
                                string channelLogin = (string)reader["channel_login"];
                            }
                        }
                    }*/
                }
            }
        }

        public static void AddAmpApprover(string ldap)
        {
            PermissionHelper permHelper = new PermissionHelper();
            var permissions = permHelper.GetPermissionsFromS3("Amp");

            string ldapID = Guid.NewGuid().ToString();

            permissions.LdapNames.Add(new Core.Models.ConfigurationModels.Permissions.LdapNameModel() { LdapName = ldap, LdapNameDescription = ldap, LdapNameID = ldapID });
            permissions.RoleToLdapNameMap["RequestApprover"].Add(ldap);

            permHelper.WritePermissionsToS3("Amp", permissions);
        }

        public static void UpdateSalesforceCredentials(string localFile, string clientID)
        {
            string bucket = "crs-data-credentials";
            string key = "salesforce/test_credentials_jwt.serialized.encrypted";
            string arn = "arn:aws:kms:us-east-1:029773783190:key/0611af9f-78f3-432d-ae85-af45507ce63a";

            //get the current file
            SalesforceCredentialsModel data = JsonConvert.DeserializeObject<SalesforceCredentialsModel>(AwsEncryption.Decrypt(bucket, key));                        
            
            //make updates            
            data.ClientID = clientID;
            
            //write updates to local file
            File.WriteAllText(localFile, JsonConvert.SerializeObject(data, Formatting.None));            

            //enrypt and upload to S3
            AwsEncryption.Encrypt(arn, localFile, bucket, key);
        }
    }
}
