﻿using Microsoft.AspNetCore.Mvc.Filters;
using Resonance.Core.Helpers.AuthHelpers;
using Resonance.Core.Models.AuthModels;
using Resonance.Core.Services;
using Resonance.Core.Services.ActivityLoggerService;
using System;
using System.Collections.Generic;
using System.Text;

namespace Resonance.Microservices.Filters
{
    public class ActivityLoggerFilter : IActionFilter, IOrderedFilter
    {
        private IActivityLoggerService _service;
        private string _message;
        public ActivityLoggerFilter(IActivityLoggerService service, string message = null)
        {
            _service = service;
            _message = message;
        }

        public int Order => 10;

        public void OnActionExecuted(ActionExecutedContext context)
        {
            string action = (string)context.RouteData.Values["action"];
            string controller = (string)context.RouteData.Values["controller"];
            string user = "";
            object tokenData = null;
            if (context.HttpContext.Items.TryGetValue(UserAuthDataContext.AuthTokenDataKey, out tokenData))
            {
                user = ((AuthTokenData)tokenData).User;
            }
            _service.LogActivity(_message ?? "", action, controller, user);
        }

        public void OnActionExecuting(ActionExecutingContext context)
        {
            
        }
    }
}
