﻿using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models.ApiModels.TwitchModels;
using Resonance.Microservices.Queries;
using System;

namespace Resonance.Microservices.Methods
{
    public class AmpAdminMethods
    {
        private static AmpAdminQuery ampAdminQuery = new AmpAdminQuery();

        public void Initialize()
        {
            ampAdminQuery.Initialize();
        }

        public UserScorecardManualDataModel GetUserManualScorecard(long twitchUserID)
        {
            try
            {
                return ampAdminQuery.GetUserManualScorecardQuery(twitchUserID);
            }
            catch (Exception ex)
            {
                Log.Error(ex);
                return null;
            }
        }

        public bool UpdateUserScorecard(UserScorecardManualDataModel data)
        {
            try
            {
                return ampAdminQuery.SetUserManualScorecardQuery();
            }
            catch(Exception ex)
            {
                Log.Error(ex);
                return false;
            }
        } 
    }
}
