﻿using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models.ServiceModels.TwitchModels;
using Resonance.Microservices.Queries;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using static Resonance.Core.Models.FilterModels.CustomTwitchDirectFilters;

namespace Resonance.Microservices.Methods
{
    public class TwitchDirectMethods
    {
        private static TwitchDirectQuery directQuery = new TwitchDirectQuery();

        public void Initialize()
        {
            var stopwatch = new Stopwatch();
            stopwatch.Start();

            directQuery.Initialize();

            stopwatch.Start();
            Log.Verbose($@"TwitchDirectMethods Initialize took {stopwatch.ElapsedMilliseconds}ms total");
        }

        public List<TwitchDirectArbitrarySummaryModel> GetArbitrarySummaryData(ArbitrarySummaryFilter filter)
        {
            var stopwatch = new Stopwatch();
            stopwatch.Start();

            var result = directQuery.GetArbitrarySummaryData(filter);

            stopwatch.Stop();
            Log.Verbose($@"SearchUsers took {stopwatch.ElapsedMilliseconds}ms total");

            return result;
        }
    }
}
