﻿using Resonance.Core.Models;
using System.Collections.Concurrent;
using System.Linq;
using TaskIdentifier = System.String;

namespace Resonance.Microservices
{
    public static class MicroserviceManager
    {
        private static ConcurrentDictionary<TaskIdentifier, MicroserviceTaskModel> taskCollection = new ConcurrentDictionary<string, MicroserviceTaskModel>();

        static MicroserviceManager()
        {

        }

        public static long CountAllTasks()
        {
            var count = taskCollection.Count;
            return count;
        }

        public static long CountRunningTasks()
        {
            var count = taskCollection.Count(x => x.Value.IsRunning);
            return count;
        }
    }
}
