﻿using Resonance.Core;
using Resonance.Core.Helpers.DatabaseHelpers;
using Resonance.Core.Helpers.LoggingHelpers;
using Resonance.Core.Models.ApiModels.TwitchModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Resonance.Microservices.Queries
{
    public class AmpAdminQuery
    {
        public void Initialize()
        {

        }

        public UserScorecardManualDataModel GetUserManualScorecardQuery(long twitchUserID)
        {
            try
            {
                using (var conn = DBManagerMysql.GetConnection(true))
                {
                    using (var command = conn.GetCommand())
                    {
                        command.CommandTimeout = 600;
                        command.CommandText =
                        $@"
                            select
                                TwitchUserID,
                                Login,
                                coalesce(HasAlerts, False) as HasAlerts,
                                coalesce(HasOverlays, False) as HasOverlays,
                                coalesce(HasAudioBalance, False) as HasAudioBalance,
                                coalesce(HasLightingBalance, False) as HasLightingBalance,
                                coalesce(HasDistinctFocalPoints, False) as HasDistinctFocalPoints,
                                coalesce(HasDiscordServer, False) as HasDiscordServer,
                                coalesce(HasRituals, False) as HasRituals,
                                coalesce(HasSocialMedia, False) as HasSocialMedia
                            from {Constants.DatabaseSchema}microservice_twitch_user_scorecard
                            where TwitchUserID = @twitchUserID
                            limit 1;
                        ";
                        command.Parameters.AddWithValue("@twitchUserID", twitchUserID);
                        using (var reader = new DataReaderWithMeasurements(command, null, "get_manual_scorecard").MysqlReader)
                        {
                            if (reader.HasRows)
                            {
                                while (reader.Read())
                                {
                                    var item = new UserScorecardManualDataModel()
                                    {
                                        TwitchUserID = reader.GetInt64(0),
                                        Login = reader.GetString(1),
                                        HasAlerts = reader.GetBoolean(2),
                                        HasOverlays = reader.GetBoolean(3),
                                        HasAudioBalance = reader.GetBoolean(4),
                                        HasLightingBalance = reader.GetBoolean(5),
                                        HasDistinctFocalPoints = reader.GetBoolean(6),
                                        HasDiscordServer = reader.GetBoolean(7),
                                        HasRituals = reader.GetBoolean(8),
                                        HasSocialMedia = reader.GetBoolean(9)
                                    };
                                    return item;
                                }
                            }
                            else
                            {
                                return null;
                            }
                        }
                    }
                }
            }
            catch(Exception ex)
            {
                Log.Error(ex);
            }
            return null;
        }

        public bool SetUserManualScorecardQuery()
        {
            throw new NotImplementedException();
        }
    }
}
