﻿using Newtonsoft.Json;
using Resonance.Core;
using Resonance.Core.Helpers.AwsHelpers;
using Resonance.Core.Models.ConfigurationModels.Jobs;
using Resonance.Core.Models.DatabaseModels.TwitchUserListingModels;
using System;
using System.Collections.Generic;

namespace Resonance.Microservices.Queries
{
    internal class TahoeAnalysisQuery
    {
        private static TahoeAnalysisQueryConfiguration config { get; set; }

        internal void Initialize(TahoeAnalysisQueryConfiguration _config)
        {
            config = _config;
        }

        public void RefreshConfiguration()
        {
            config.MaxDate = DateTime.UtcNow.Date;
        }

        private string ProcessResult(ref List<TwitchUserListingModel> data)
        {
            if (data == null || data.Count == 0)
            {
                return null;
            }

            var filepath = $@"{ConstantsWorker.WorkerS3Path}twitch-user-listing/{config.AggregationType}/{Guid.NewGuid().ToString().Replace("-", "_")}.json.gz";
            S3Helper.WriteStringToS3(JsonConvert.SerializeObject(data), ConstantsWorker.WorkerS3Bucket, filepath, true);
            return filepath;
        }
    }
}
