KILL_ALL=false
BUILD_MAC=false
LAUNCH=false
VALID=false

echo $@

# if [[ $1 == "build-mac" ]]; then
#     BUILD_MAC=true
# elif [[ $1 == "launch" ]]; then
#     LAUNCH=true

if [[ "$@" == *'build-mac'* ]]; then
    BUILD_MAC=true
    VALID=true
fi

if [[ "$@" == *'launch'* ]]; then
    LAUNCH=true
    VALID=true
fi

if [[ "$@" == *'kill-all'* ]]; then
    KILL_ALL=true
    VALID=true
fi

if [[ $VALID = false ]]; then
    echo "
    Usage:

    -- One of the following commands --
    sh dev.sh build-mac
    sh dev.sh launch
    sh dev.sh kill-all

    -- ...or you can do multiple at once --
    sh dev.sh build-mac launch
    "
fi

if [[ $KILL_ALL = true ]]; then
    echo "-- Killing all procs (dotnet, resonance) --"
    pkill -f resonance
    pkill dotnet
fi

if [[ $BUILD_MAC = true ]]; then
    echo "-- Building and Deploying Services (local) --"
    cd DeployScripts
    sh Deploy-Development-Mac-Local.sh
    cd ..
fi

if [[ $LAUNCH = true ]]; then
    echo "-- Launching Services (local) --"
    cd LaunchScripts
    environment=Development sh RunWeb.sh
    cd ..
fi
