# Roster

[![Build Status](https://jenkins-og.xarth.tv/buildStatus/icon?job=cb-roster-build)](https://jenkins-og.xarth.tv/job/cb-roster-build)

Roster is the web service for Twitch Teams.

[Runbook](./docs/runbook.md) | [SLA](./docs/service_level_agreement.md)

## Environments

- Staging: http://staging.roster.cb.twitch.a2z.com

- Production: http://prod.roster.cb.twitch.a2z.com

## Connecting

Roster's VPC endpoints have [TPM](https://docs.fulton.twitch.a2z.com/docs/tpm.html?search=tpm#connecting-to-an-onboarded-service-so-you-can-call-them) enabled, meaning connection requests from any Twitch-owned AWS account is auto-accepted.
The VPC Endpoint service name and hostname can be found at the [service catalog entry](https://servicecatalog.internal.justin.tv/services/297).

## Development

### Setup

Follow the [Setup](./docs/setup.md) guide to prepare your machine (macOS) for local development.

### Vendor

The [Vendor](./docs/vendor.md) page describes how vendor packages are managed in this project.

### Running

Run `redis-server` to start a local Redis server at the default `6379` port.

Run `make dev_api` at the project root to start Roster API's HTTP server.

Run `make dev_worker` at the project root to start Roster worker's HTTP server.

### DB migrations

All migrations are located in `migrations` folder to generate new use command

`migrate create -ext sql -dir migrations {name_of_migration}`

To run migrations on the server

`migrate -database postgres://cb-roster-staging.cqyyxr1hxrhn.us-west-2.rds.amazonaws.com:5432/roster up`

## Testing

### Lint

Run `make lint` at the project root to lint all packages except [`vendor/`](./vendor).

See the [Go Meta Linter](./docs/setup.md#go-meta-linter) section for setting up the linter.

### Mocking

For unit testing, service interfaces used by the app are mocked.

The [Mocking](./docs/mocking.md) document includes instructions for generating and utilizing mocks.

## API

See the [API](./docs/api.md) page for details regarding the Roster API and Go client library.

## Building & Deploying

The [Deployment](./docs/deployment.md) page describes the steps needed to deploy to Elastic Beanstalk.

The [Continuous Integration](./docs/continuous_integration.md) page describes the Jenkins jobs configured to build the Go executable and to deploy to Elastic Beanstalk.

## Troubleshooting & Recovery

The [Troubleshooting and Recovery](./docs/troubleshooting_and_recovery.md) page describes how to find the error logs, rollback commits, and recover the database to a previous time.
