package main

import (
	"context"
	"fmt"
	"time"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"code.justin.tv/cb/roster/config"
	"code.justin.tv/cb/roster/internal/clients/pushy"
)

func main() {
	env := config.Environment
	config.Load()

	pushyClient, err := pushy.NewClient(&telemetry.SampleReporter{})
	if err != nil {
		fmt.Println(err)
		return
	}

	err = pushyClient.PublishInvite(context.Background(), "111997428", "111997428")
	fmt.Println(err)
	for {
		time.Sleep(1 * time.Second)
	}
}
