package v1

// GetChannelMembershipsResponse is the response body of
// the GET /v1/channels/:channel_id/memberships API.
type GetChannelMembershipsResponse struct {
	Data []GetChannelMembershipsData `json:"data"`
}

// GetChannelMembershipsData contains the data of GetChannelMembershipsResponse.
type GetChannelMembershipsData struct {
	Primary         bool `json:"primary"`
	RevenueRevealed bool `json:"revenue_revealed"`
	StatsRevealed   bool `json:"stats_revealed"`
	Team            Team `json:"team"`
}

// GetChannelMembershipsRequestParams contains parameters for
// making a GET /v1/channels/:channel_id/memberships request.
type GetChannelMembershipsRequestParams struct {
	ChannelID string
}
