package v1

// GetTeamMembershipsRequestParams contains optional parameters
// for making a GET /v1/teams/:team_id/memberships request.
type GetTeamMembershipsRequestParams struct {
	TeamID          string // route
	RevenueRevealed *bool  // query (optional)
	StatsRevealed   *bool  // query (optional)
}

// GetTeamMembershipsResponse is the response body of the
// GET /v1/teams/:team_id/memberships API.
type GetTeamMembershipsResponse struct {
	Meta GetTeamMembershipsMeta   `json:"meta"`
	Data []GetTeamMembershipsData `json:"data"`
}

// GetTeamMembershipsMeta contains the metadata of GetTeamMembersResponse.
type GetTeamMembershipsMeta struct {
	Team Team `json:"team"`
}

// GetTeamMembershipsData is a single unit of GetTeamMembersResponse.Data.
type GetTeamMembershipsData struct {
	ChannelID       string `json:"channel_id"`
	TeamID          string `json:"team_id"`
	RevenueRevealed bool   `json:"revenue_revealed"`
	StatsRevealed   bool   `json:"stats_revealed"`
}
