#!/usr/bin/env node
import cdk = require('@aws-cdk/core');
import ts3 = require('@twitch-easymode/twitch-s3');
import { S3Policy } from '../lib/s3-policy';
import { CapacityPlanningStack } from '../lib/capacity-planning';

const primaryRegion = "us-west-2";
const replicaRegion = "us-east-2";

const app = new cdk.App();
// twitch-teams-aws
buildS3Stacks(app, 'prod', '570264701802', ['arn:aws:iam::989470033077:role/cb-roster-production']); 
buildCapacityPlanningStack(app, 'prod', '570264701802');

// twitch-teams-dev
buildS3Stacks(app, 'staging', '491086465639', ['arn:aws:iam::989470033077:role/cb-roster-staging']); 
buildCapacityPlanningStack(app, 'staging', '491086465639');

function buildS3Stacks(parent: cdk.App, environment: string, accountID: string, readWriteRoleArns: string[]) {
	const s3Stacks = new ts3.Buckets(parent, `${environment}RosterS3`, {
		bucketPrefix: `roster-${environment}-assets`,
		primaryAccount: accountID,
		replicaAccount: accountID,
		primaryRegion: primaryRegion,
		replicaRegion: replicaRegion,
	});

	const policy = new S3Policy(s3Stacks.primary, {
		bucket: s3Stacks.primary.bucket,
		readWriteRoleArns: readWriteRoleArns,
	})
}

function buildCapacityPlanningStack(parent: cdk.App, environment: string, accountID: string) {
	new CapacityPlanningStack(parent, `${environment}RosterCapacityPlanning`, {
		env: {
			account: accountID,
			region: primaryRegion,
		}
	})
}
