import cdk = require('@aws-cdk/core');
import s3 = require('@aws-cdk/aws-s3');
import iam = require('@aws-cdk/aws-iam');

interface S3PolicyProps {
	bucket: s3.IBucket,
	readWriteRoleArns: string[],
}

export class S3Policy {
	constructor(stack: cdk.Stack, props: S3PolicyProps) {
		const roles = props.readWriteRoleArns.map(roleArn => iam.Role.fromRoleArn(stack, "serviceRole", roleArn));
		const policy = new iam.PolicyStatement({
			principals: roles,
			resources: [ props.bucket.bucketArn, `${props.bucket.bucketArn}/*` ],
			actions: [
				"s3:*"
			],
			effect: iam.Effect.ALLOW,
		});
		props.bucket.addToResourcePolicy(policy);
	}
}
