package roster

import (
	"code.justin.tv/foundation/twitchclient"
	. "github.com/onsi/ginkgo"
	. "github.com/onsi/gomega"
)

var _ = Describe("Client", func() {
	Context("missing a host in config", func() {
		It("errors", func() {
			_, err := NewClient(twitchclient.ClientConf{})
			Expect(err).To(HaveOccurred())
			Expect(err.Error()).To(Equal("Host cannot be blank"))
		})
	})

	Context("with valid config", func() {
		It("does not error", func() {
			_, err := NewClient(twitchclient.ClientConf{
				Host: "test-host",
			})
			Expect(err).NotTo(HaveOccurred())
		})
	})
})
