package roster

import (
	"context"
	"fmt"
	"net/http"
	"strconv"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1LiveFeaturedChannels makes a GET request to the Roster Service for
// a given team's live featured channels.
func (c *clientImpl) GetV1LiveFeaturedChannels(ctx context.Context, params v1.GetLiveFeaturedChannelsRequestParams, reqOpts *twitchclient.ReqOpts) (*v1.GetLiveFeaturedChannelsResponse, error) {
	path := fmt.Sprintf("/v1/teams/%s/live_featured_channels", params.TeamID)
	response := &v1.GetLiveFeaturedChannelsResponse{}

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-roster.v1.get_live_featured_channels",
		StatSampleRate: 0.1,
	})

	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	query := req.URL.Query()

	if params.Limit != 0 {
		query.Set("limit", strconv.FormatUint(uint64(params.Limit), 10))
	}

	req.URL.RawQuery = query.Encode()

	req.Header.Set("Content-Type", "application/json")

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
