package roster

import (
	"context"
	"fmt"
	"net/http"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1TeamInvitations makes a GET request to the Roster Service for
// a given team's invitations.
func (c *clientImpl) GetV1TeamInvitations(ctx context.Context, teamID string, reqOpts *twitchclient.ReqOpts) (*v1.GetTeamInvitationsResponse, error) {
	path := fmt.Sprintf("/v1/teams/%s/invitations", teamID)
	response := &v1.GetTeamInvitationsResponse{}

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-roster.v1.get_team_invitations",
		StatSampleRate: 0.1,
	})

	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	_, err = c.DoJSON(ctx, response, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
