package roster

import (
	"context"
	"fmt"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/foundation/twitchclient"
)

func (c *clientImpl) PostV1FeaturedChannels(ctx context.Context, params v1.PostFeaturedChannelsRequestParams, reqOpts *twitchclient.ReqOpts) (*v1.PostFeaturedChannelsResponse, error) {
	path := fmt.Sprintf("/v1/teams/%s/featured_channels", params.TeamID)
	response := &v1.PostFeaturedChannelsResponse{}
	reqBody := v1.PostFeaturedChannelsRequestBody{
		ChannelID: params.ChannelID,
	}

	err := c.post(ctx, path, "featured_channels", reqBody, response, reqOpts)
	if err != nil {
		return nil, err
	}

	return response, nil
}
