# Continuous Integration

Continuous integration allows for fast iterations.

By automatically building the Go executable, we could quickly deploy a branch to an environment (e.g. staging).

## Build

For every GitHub `push` event, a Jenkins build job is kicked off through the Jenkins webhook.

[jenkins.groovy](../jenkins.groovy) configures the [`cb-roster-build`](https://jenkins-og.xarth.tv/view/Creator%20Business/job/cb-roster-build/) Jenkins multi-job, which executes two concurrent build jobs:

1. [`cb-roster-build-api`](https://jenkins-og.xarth.tv/view/Creator%20Business/job/cb-roster-build-api/)
2. [`cb-roster-build-worker`](https://jenkins-og.xarth.tv/view/Creator%20Business/job/cb-roster-build-worker/)

[Manta](https://git.xarth.tv/dta/manta) is used to build the Go executable in an isolated, reproducible build environment via Docker.

The artifact created by Manta is copied into a new Docker image and pushed to the Twitch internal [Docker registry](https://wiki.twitch.com/display/ENG/Docker+Registry).

## Deployment

[jenkins.groovy](../jenkins.groovy) also configures the [`cb-roster-deploy`](https://jenkins-og.xarth.tv/view/Creator%20Business/job/cb-roster-deploy/) Jenkins deployment multi-job, which executes two concurrent deployment jobs:

1. [`cb-roster-deploy-api`](https://jenkins-og.xarth.tv/view/Creator%20Business/job/cb-roster-deploy-api/)
2. [`cb-roster-deploy-worker`](https://jenkins-og.xarth.tv/view/Creator%20Business/job/cb-roster-deploy-worker/)

### Elastic Beanstalk CLI

The EB CLI is used to deploy an application version.

A given git commit maps to a Docker image in the Docker registry.

Each EC2 instance of the Elastic Beanstalk application pulls the Docker image during the deployment.

### Manual Deployment

[deploy.json](../deploy.json) configures the [Skadi](https://wiki.twitch.com/display/ENG/Skadi) deployment UI -- [Clean Deploy](https://clean-deploy.internal.justin.tv/#/cb/roster) -- to trigger the Jenkins build job.
