## Deploying Roster
Deployment is done using [clean-deploy](https://clean-deploy.internal.justin.tv/#/cb/roster).

1. Create a new branch for a feature in [cb/roster](https://git.xarth.tv/cb/roster).
2. After writing your feature, you can test locally by running `make dev_api` (for API changes) or `make dev_worker` (for worker changes) and making calls to `localhost`.
3. Using clean-deploy, deploy your branch to the Roster Staging environment and test it. Errors can be found logged to [Rollbar](https://rollbar.com/Twitch/CB_Roster/items/), or, if you prefer, in the slack channel #cb-deploys.
4. Create a pull request for your branch. You can ask in the slack channel #creator-business for a review.
5. After your PR is approved, merge your branch and deploy master to production using clean-deploy. You can test from a team page on twitch (`https://www.twitch.tv/team/:team_name`), from a team's dashboard (`https://www.twitch.tv/teams/:team_name/dashboard`), or by calling Roster directly. Production errors are still logged in [Rollbar](https://rollbar.com/Twitch/CB_Roster/items/).
6. Verify that the Elastic Beanstalk applications are healthy by visiting the [API dashboard](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-roster-production&environmentId=e-7ksqjmvq2m) and the [worker dashboard](https://us-west-2.console.aws.amazon.com/elasticbeanstalk/home?region=us-west-2#/environment/dashboard?applicationName=cb-roster-production&environmentId=e-dwsar9r923).

## Rollbacks
The fastest way to rollback a change is to use clean-deploy. Click the arrow next to the master branch, and select a previous version of the application. Deploy that version to production to rollback a change.
Make sure to make a new pull request to either fix your error, or revert the change. During this time, it's probably a good idea to freeze Roster from any deployments to make sure your broken change is not re-deployed. You can freeze the project from clean-deploy by clicking the `freeze roster` button in the top right corner.
