# Mocking

[Mockery](https://github.com/vektra/mockery) is used to generate mocks of the service interfaces used by the app.

## Installing

```
go get -u github.com/vektra/mockery/.../
```

## Generating

The `make mocks` command generates a mock for each exported interface.

See the [`Makefile`](../Makefile) for the included directories.

## Usage

In a test, mock a method invocation of the interface.

Given an interface having a method that is invoked in the code path:

```go
type FooService interface {
  Bar(input string) string
}

type App struct {
  foo FooService
}

func (a *App) Do(input string) string {
  return a.foo.Bar(input)
}
```

We use the generated mock to stub the method with `theMockedInstance.On("MethodNameHere", arg1)`:

```go
func TestAppDo(t *testing.T) {
  input := "input for FooService.Bar()"
  output := "output from FooService.Bar()"

  app := App{
    foo: &mocks.FooService{},
  }

  app.foo.On("Bar", input).Return(output)

  if done := app.Do(input); done != output {
    t.Error("expected %s, got %s", output, done)
  }
}
```
