# Setup

Follow the steps to setup your machine (macOS only) for local development.

## Prerequisites

### Go

Installing Go (>= `1.10.2`):

```sh
brew install go
```

Setting `GOPATH` and `PATH` in `~/.bash_profile` (or equivalent):

```sh
export GOPATH=$HOME/go
export PATH=$PATH:$GOPATH/bin
export PATH=$PATH:/usr/local/opt/go/libexec/bin
```

The `GOPATH` above assumes that your Go workspace is located at `~/go`.

### Redis

Installing Redis:

```sh
brew install redis
```

### PostgreSQL

Installing PostgreSQL (>= `9.6.5`):

```sh
brew install postgres
```

## Go Meta Linter

Installing [Go Meta Linter](https://github.com/alecthomas/gometalinter):

```sh
go get -u github.com/alecthomas/gometalinter
gometalinter --install
```

See the [Lint](../README.md#lint) section for the linter usage.

## Glide

Installing [Glide](https://github.com/Masterminds/glide) via Homebrew:

```sh
brew install glide
```

See the [Vendor](./vendor.md) page for usage.

### Glide Vendor Cleaner

Installing [Glide Vendor Cleaner](https://github.com/sgotti/glide-vc):

```sh
go get -u github.com/sgotti/glide-vc
```

## DB

Creating the Roster database:

```sh
createdb roster
psql -h localhost -d roster < internal/db/schema.sql
```

## Ginkgo

Installing [Ginkgo](https://github.com/onsi/ginkgo):

```sh
go get -u github.com/onsi/ginkgo/ginkgo
```
