# Vendor

Vendor packages are installed via [Glide](./setup.md#glide), and are stripped of excessive files and packages using [Glide Vendor Cleaner](./setup.md#glide-vendor-cleaner).

Vendor packages are committed into the project history and used to run tests and to build the Go executable.

## Pinning Package Version

For any external package that is directly imported in the project, pin the package and version in [`glide.yaml`](../glide.yaml).

### Example

```yaml
package: code.justin.tv/cb/roster
import:
- package: github.com/pkg/errors
  version: 0.8.0
```

## Installing & Updating

Run `make update` at the project root to import new vendor packages and to update unpinned packages (which should only be the dependencies of vendor packages).
