package api

import (
	"fmt"
	"net/http"

	"code.justin.tv/cb/roster/internal/db"
	"code.justin.tv/cb/roster/internal/httputil"
	"code.justin.tv/web/users-service/client/channels"
)

func (s *Server) deleteV1FeaturedChannel(w http.ResponseWriter, req *http.Request) {
	jsonWriter := httputil.NewJSONResponseWriter(w)
	ctx := req.Context()

	teamID := ctx.Value(contextKeyTeamID).(string)
	channelID := ctx.Value(contextKeyChannelID).(string)

	_, err := s.dbReader.GetTeamByID(ctx, teamID)
	if err == db.ErrNoTeam {
		jsonWriter.NotFound(fmt.Sprintf("team with id %s not found", teamID))
		return
	}
	if err != nil {
		jsonWriter.InternalServerError("db: failed to query team", err)
		return
	}

	_, err = s.users.Get(ctx, channelID, nil)
	switch err.(type) {
	case *channels.ErrChannelNotFound:
		jsonWriter.NotFound(fmt.Sprintf("channel with id %s not found", channelID))
		return
	case error:
		jsonWriter.InternalServerError("users_service: failed to look up channel", err)
		return
	}

	err = s.dbWriter.DeleteFeaturedChannel(ctx, teamID, channelID)
	if err == db.ErrNoRowFoundForDeletion {
		jsonWriter.NotFound(fmt.Sprintf("featuring of channel with id %s by team with id %s not found", channelID, teamID))
		return
	}
	if err != nil {
		jsonWriter.InternalServerError("db: failed to delete featured channel", err)
		return
	}

	w.WriteHeader(http.StatusNoContent)
}
