package api

import (
	"fmt"
	"net/http"

	"code.justin.tv/cb/roster/internal/db"
	"code.justin.tv/cb/roster/internal/httputil"
)

// DELETE /v1/teams/:team_id/channels/:channel_id/invitation
func (s *Server) deleteV1TeamInvitation(w http.ResponseWriter, req *http.Request) {
	jsonWriter := httputil.NewJSONResponseWriter(w)
	ctx := req.Context()

	teamID := ctx.Value(contextKeyTeamID).(string)
	channelID := ctx.Value(contextKeyChannelID).(string)

	_, err := s.dbReader.GetTeamByID(ctx, teamID)
	switch {
	case err == db.ErrNoTeam:
		jsonWriter.NotFound(fmt.Sprintf("team with id %s not found", teamID))
		return
	case err != nil:
		jsonWriter.InternalServerError("failed to query team from db", err)
		return
	}

	err = s.dbWriter.DeleteInvitation(ctx, teamID, channelID)
	switch {
	case err == db.ErrNoRowFoundForDeletion:
		jsonWriter.NotFound(fmt.Sprintf("invitation for channel with id %s on team with id %s not found", channelID, teamID))
		return
	case err != nil:
		jsonWriter.InternalServerError("failed to delete invitation from db", err)
		return
	}

	w.WriteHeader(http.StatusNoContent)
}
