package api

import (
	"fmt"
	"net/http"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/cb/roster/internal/db"
	"code.justin.tv/cb/roster/internal/httputil"
	"code.justin.tv/web/users-service/client/channels"
)

func (s *Server) getV1ChannelInvitations(w http.ResponseWriter, req *http.Request) {
	jsonWriter := httputil.NewJSONResponseWriter(w)
	ctx := req.Context()

	channelID := ctx.Value(contextKeyChannelID).(string)

	_, err := s.users.Get(ctx, channelID, nil)
	switch err.(type) {
	case *channels.ErrChannelNotFound:
		jsonWriter.NotFound(fmt.Sprintf("channel with ID %s not found", channelID))
		return
	case error:
		jsonWriter.InternalServerError("users: failed to query channel", err)
		return
	}

	teams, err := s.dbReader.GetInvitingTeamsForChannel(ctx, channelID)
	if err != nil {
		jsonWriter.InternalServerError("db: failed to query for channel's invitations", err)
		return
	}

	response := v1.GetChannelInvitationsResponse{
		Data: toV1ChannelInvitations(teams),
	}

	jsonWriter.OK(response)
}

func toV1ChannelInvitations(teams []db.Team) []v1.GetChannelInvitationsData {
	invitations := make([]v1.GetChannelInvitationsData, len(teams))

	for idx, team := range teams {
		invitations[idx] = v1.GetChannelInvitationsData{
			Team: transformDBTeamToV1Team(team),
		}
	}

	return invitations
}
