package api

import (
	"fmt"
	"net/http"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/cb/roster/internal/db"
	"code.justin.tv/cb/roster/internal/httputil"
)

// GET /v1/teams/:team_id/invitations
func (s *Server) getV1TeamInvitations(w http.ResponseWriter, req *http.Request) {
	jsonWriter := httputil.NewJSONResponseWriter(w)
	ctx := req.Context()

	teamID := ctx.Value(contextKeyTeamID).(string)

	_, err := s.dbReader.GetTeamByID(ctx, teamID)
	switch {
	case err == db.ErrNoTeam:
		jsonWriter.NotFound(fmt.Sprintf("team with id %s not found", teamID))
		return
	case err != nil:
		jsonWriter.InternalServerError("failed to query team from db", err)
		return
	}

	invitations, err := s.dbReader.GetTeamInvitations(ctx, teamID)
	if err != nil {
		jsonWriter.InternalServerError("failed to query team invitations from db", err)
		return
	}

	data := make([]v1.GetTeamInvitationsData, len(invitations))
	for idx, invitation := range invitations {
		data[idx] = v1.GetTeamInvitationsData{
			ChannelID: invitation.ChannelID,
			TeamID:    invitation.TeamID,
		}
	}

	response := v1.GetTeamInvitationsResponse{
		Data: data,
	}

	jsonWriter.OK(response)
}
