package api

import (
	"encoding/json"
	"errors"
	"io"

	"code.justin.tv/cb/roster/api/v1"
)

func getDisplayPositionFromRequestBody(reqBody io.ReadCloser) (uint, error) {
	var decoded v1.PatchChannelDisplayPositionRequestBody

	err := json.NewDecoder(reqBody).Decode(&decoded)
	if err != nil {
		return 0, errors.New("invalid display position (must be a positive number)")
	}
	if decoded.DisplayPosition == nil {
		return 0, errors.New("invalid display position (must exist)")
	}

	return *decoded.DisplayPosition, nil
}
