// Code generated by mockery v1.0.0
package mocks

import context "context"
import db "code.justin.tv/cb/roster/internal/db"
import mock "github.com/stretchr/testify/mock"

// DBReader is an autogenerated mock type for the DBReader type
type DBReader struct {
	mock.Mock
}

// GetChannelMemberships provides a mock function with given fields: ctx, channelID
func (_m *DBReader) GetChannelMemberships(ctx context.Context, channelID string) ([]db.Membership, error) {
	ret := _m.Called(ctx, channelID)

	var r0 []db.Membership
	if rf, ok := ret.Get(0).(func(context.Context, string) []db.Membership); ok {
		r0 = rf(ctx, channelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]db.Membership)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetFeaturedChannel provides a mock function with given fields: ctx, teamID, channelID
func (_m *DBReader) GetFeaturedChannel(ctx context.Context, teamID string, channelID string) (db.FeaturedChannel, error) {
	ret := _m.Called(ctx, teamID, channelID)

	var r0 db.FeaturedChannel
	if rf, ok := ret.Get(0).(func(context.Context, string, string) db.FeaturedChannel); ok {
		r0 = rf(ctx, teamID, channelID)
	} else {
		r0 = ret.Get(0).(db.FeaturedChannel)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, teamID, channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetFeaturedChannels provides a mock function with given fields: ctx, teamID
func (_m *DBReader) GetFeaturedChannels(ctx context.Context, teamID string) ([]db.FeaturedChannel, error) {
	ret := _m.Called(ctx, teamID)

	var r0 []db.FeaturedChannel
	if rf, ok := ret.Get(0).(func(context.Context, string) []db.FeaturedChannel); ok {
		r0 = rf(ctx, teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]db.FeaturedChannel)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetInvitation provides a mock function with given fields: ctx, teamID, channelID
func (_m *DBReader) GetInvitation(ctx context.Context, teamID string, channelID string) (db.Invitation, error) {
	ret := _m.Called(ctx, teamID, channelID)

	var r0 db.Invitation
	if rf, ok := ret.Get(0).(func(context.Context, string, string) db.Invitation); ok {
		r0 = rf(ctx, teamID, channelID)
	} else {
		r0 = ret.Get(0).(db.Invitation)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, teamID, channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetInvitingTeamsForChannel provides a mock function with given fields: ctx, channelID
func (_m *DBReader) GetInvitingTeamsForChannel(ctx context.Context, channelID string) ([]db.Team, error) {
	ret := _m.Called(ctx, channelID)

	var r0 []db.Team
	if rf, ok := ret.Get(0).(func(context.Context, string) []db.Team); ok {
		r0 = rf(ctx, channelID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]db.Team)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetMembership provides a mock function with given fields: ctx, teamID, channelID
func (_m *DBReader) GetMembership(ctx context.Context, teamID string, channelID string) (db.Membership, error) {
	ret := _m.Called(ctx, teamID, channelID)

	var r0 db.Membership
	if rf, ok := ret.Get(0).(func(context.Context, string, string) db.Membership); ok {
		r0 = rf(ctx, teamID, channelID)
	} else {
		r0 = ret.Get(0).(db.Membership)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, teamID, channelID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTeamByID provides a mock function with given fields: ctx, id
func (_m *DBReader) GetTeamByID(ctx context.Context, id string) (db.Team, error) {
	ret := _m.Called(ctx, id)

	var r0 db.Team
	if rf, ok := ret.Get(0).(func(context.Context, string) db.Team); ok {
		r0 = rf(ctx, id)
	} else {
		r0 = ret.Get(0).(db.Team)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTeamInvitations provides a mock function with given fields: ctx, teamID
func (_m *DBReader) GetTeamInvitations(ctx context.Context, teamID string) ([]db.Invitation, error) {
	ret := _m.Called(ctx, teamID)

	var r0 []db.Invitation
	if rf, ok := ret.Get(0).(func(context.Context, string) []db.Invitation); ok {
		r0 = rf(ctx, teamID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]db.Invitation)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string) error); ok {
		r1 = rf(ctx, teamID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTeamMemberships provides a mock function with given fields: ctx, teamID, filter
func (_m *DBReader) GetTeamMemberships(ctx context.Context, teamID string, filter *db.MembershipsFilter) ([]db.Membership, error) {
	ret := _m.Called(ctx, teamID, filter)

	var r0 []db.Membership
	if rf, ok := ret.Get(0).(func(context.Context, string, *db.MembershipsFilter) []db.Membership); ok {
		r0 = rf(ctx, teamID, filter)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]db.Membership)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *db.MembershipsFilter) error); ok {
		r1 = rf(ctx, teamID, filter)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTeams provides a mock function with given fields: ctx, filter
func (_m *DBReader) GetTeams(ctx context.Context, filter db.TeamsFilter) ([]db.Team, error) {
	ret := _m.Called(ctx, filter)

	var r0 []db.Team
	if rf, ok := ret.Get(0).(func(context.Context, db.TeamsFilter) []db.Team); ok {
		r0 = rf(ctx, filter)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]db.Team)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, db.TeamsFilter) error); ok {
		r1 = rf(ctx, filter)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetTeamsCount provides a mock function with given fields: ctx, filter
func (_m *DBReader) GetTeamsCount(ctx context.Context, filter db.TeamsFilter) (uint, error) {
	ret := _m.Called(ctx, filter)

	var r0 uint
	if rf, ok := ret.Get(0).(func(context.Context, db.TeamsFilter) uint); ok {
		r0 = rf(ctx, filter)
	} else {
		r0 = ret.Get(0).(uint)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, db.TeamsFilter) error); ok {
		r1 = rf(ctx, filter)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SearchTeams provides a mock function with given fields: ctx, filter
func (_m *DBReader) SearchTeams(ctx context.Context, filter db.SearchTeamsFilter) ([]db.Team, error) {
	ret := _m.Called(ctx, filter)

	var r0 []db.Team
	if rf, ok := ret.Get(0).(func(context.Context, db.SearchTeamsFilter) []db.Team); ok {
		r0 = rf(ctx, filter)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]db.Team)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, db.SearchTeamsFilter) error); ok {
		r1 = rf(ctx, filter)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// SearchTeamsCount provides a mock function with given fields: ctx, filter
func (_m *DBReader) SearchTeamsCount(ctx context.Context, filter db.SearchTeamsFilter) (uint, error) {
	ret := _m.Called(ctx, filter)

	var r0 uint
	if rf, ok := ret.Get(0).(func(context.Context, db.SearchTeamsFilter) uint); ok {
		r0 = rf(ctx, filter)
	} else {
		r0 = ret.Get(0).(uint)
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, db.SearchTeamsFilter) error); ok {
		r1 = rf(ctx, filter)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
