package api

import (
	"fmt"
	"net/http"

	"code.justin.tv/cb/roster/internal/db"
	"code.justin.tv/cb/roster/internal/httputil"
)

func (s *Server) patchV1FeaturedChannel(w http.ResponseWriter, req *http.Request) {
	jsonWriter := httputil.NewJSONResponseWriter(w)
	ctx := req.Context()

	teamID := ctx.Value(contextKeyTeamID).(string)
	channelID := ctx.Value(contextKeyChannelID).(string)

	displayPosition, err := getDisplayPositionFromRequestBody(req.Body)
	if err != nil {
		jsonWriter.BadRequest(err.Error())
		return
	}

	_, err = s.dbReader.GetTeamByID(ctx, teamID)
	if err == db.ErrNoTeam {
		jsonWriter.NotFound(fmt.Sprintf("team with id %s not found", teamID))
		return
	}
	if err != nil {
		jsonWriter.InternalServerError("db: failed to query team", err)
		return
	}

	err = s.dbWriter.UpdateFeaturedChannelDisplayPosition(ctx, teamID, channelID, displayPosition)
	if err == db.ErrNoFeaturedChannelForUpdate {
		jsonWriter.NotFound(fmt.Sprintf("channel with id %s not currently featured by team %s", channelID, teamID))
		return
	}
	if err != nil {
		jsonWriter.InternalServerError("db: failed to update featured channel display order", err)
		return
	}

	w.WriteHeader(http.StatusNoContent)
}
