package api

import (
	"context"
	"fmt"
	"net/http"

	"code.justin.tv/cb/roster/internal/db"
	"code.justin.tv/cb/roster/internal/httputil"
)

func (s *Server) patchV1TeamMembership(w http.ResponseWriter, req *http.Request) {
	jsonWriter := httputil.NewJSONResponseWriter(w)
	ctx := req.Context()

	teamID := ctx.Value(contextKeyTeamID).(string)
	channelID := ctx.Value(contextKeyChannelID).(string)

	displayPosition, err := getDisplayPositionFromRequestBody(req.Body)
	if err != nil {
		jsonWriter.BadRequest(err.Error())
		return
	}

	_, err = s.dbReader.GetTeamByID(ctx, teamID)
	if err != nil {
		switch err {
		case db.ErrNoTeam:
			jsonWriter.NotFound(fmt.Sprintf("team with id %s not found", teamID))
		default:
			jsonWriter.InternalServerError("db: failed to query team", err)
		}
		return
	}

	err = s.dbWriter.UpdateMembershipDisplayPosition(ctx, teamID, channelID, displayPosition)
	if err != nil {
		switch err {
		case db.ErrNoMembershipForUpdate:
			jsonWriter.NotFound(fmt.Sprintf("membership of channel with id %s in team %s not found", channelID, teamID))
		default:
			jsonWriter.InternalServerError("db: failed to update membership display order", err)
		}
		return
	}

	go s.expireCachedTeamMemberships(context.Background(), teamID)

	w.WriteHeader(http.StatusNoContent)
}
