package api

import (
	"context"
	"net/http"
	"strconv"

	"code.justin.tv/cb/roster/internal/httputil"
	"goji.io/pat"
)

type contextKey int

const (
	contextKeyTeamID contextKey = iota
	contextKeyChannelID
	contextKeyUserID
)

func validateNumericTeamID(inner http.Handler) http.Handler {
	middleware := func(w http.ResponseWriter, req *http.Request) {
		teamID := pat.Param(req, "team_id")

		if _, err := strconv.ParseInt(teamID, 10, 64); err != nil {
			httputil.NewJSONResponseWriter(w).BadRequest("invalid team id (must be numeric)")
			return
		}

		ctx := context.WithValue(req.Context(), contextKeyTeamID, teamID)

		inner.ServeHTTP(w, req.WithContext(ctx))
	}

	return http.HandlerFunc(middleware)
}

func validateNumericChannelID(inner http.Handler) http.Handler {
	middleware := func(w http.ResponseWriter, req *http.Request) {
		channelID := pat.Param(req, "channel_id")

		if _, err := strconv.ParseInt(channelID, 10, 64); err != nil {
			httputil.NewJSONResponseWriter(w).BadRequest("invalid channel id (must be numeric)")
			return
		}

		ctx := context.WithValue(req.Context(), contextKeyChannelID, channelID)

		inner.ServeHTTP(w, req.WithContext(ctx))
	}

	return http.HandlerFunc(middleware)
}

func validateNumericUserID(inner http.Handler) http.Handler {
	middleware := func(w http.ResponseWriter, req *http.Request) {
		userID := pat.Param(req, "user_id")

		if _, err := strconv.ParseInt(userID, 10, 64); err != nil {
			httputil.NewJSONResponseWriter(w).BadRequest("invalid user id (must be numeric)")
			return
		}

		ctx := context.WithValue(req.Context(), contextKeyUserID, userID)

		inner.ServeHTTP(w, req.WithContext(ctx))
	}

	return http.HandlerFunc(middleware)
}
