package api

import (
	"encoding/json"

	"code.justin.tv/cb/roster/api/v1"
	"code.justin.tv/cb/roster/internal/db"
	log "github.com/sirupsen/logrus"
)

func transformDBTeamToV1Team(team db.Team) v1.Team {
	return v1.Team{
		ID:                  team.ID,
		Name:                team.Name,
		UserID:              team.UserID,
		DisplayName:         team.DisplayName,
		DescriptionHTML:     team.DescriptionHTML(),
		DescriptionMarkdown: team.DescriptionMarkdown(),
		LogoID:              extractImageID(team.Logo),
		LogoURL:             extractImageURL(team.Logo),
		BannerID:            extractImageID(team.Banner),
		BannerURL:           extractImageURL(team.Banner),
		BackgroundImageID:   extractImageID(team.Background),
		BackgroundImageURL:  extractImageURL(team.Background),
		CreatedAt:           team.CreatedAt,
		UpdatedAt:           team.UpdatedAt,
	}
}

func extractImageID(image *db.Image) *string {
	if image == nil {
		return nil
	}

	return &image.ID
}

func extractImageURL(image *db.Image) *string {
	if image == nil {
		return nil
	}

	return &image.URL
}

func jsonString(data interface{}) string {
	marshaled, err := json.Marshal(data)
	if err != nil {
		log.WithError(err).WithField("data", data).Warn("failed to json marshal")
		return ""
	}

	return string(marshaled)
}
