package authorization

import (
	"fmt"
	"io/ioutil"

	"code.justin.tv/common/goauthorization"
	"github.com/pkg/errors"
)

// Decoder is a wrapper for goauthorization.Decoder.
type Decoder struct {
	goauthorization.Decoder
}

// NewDecoder instantiates a Decoder.
func NewDecoder(keyPath string) (*Decoder, error) {
	key, err := ioutil.ReadFile(keyPath)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("authorization: failed to read file at %s", keyPath))
	}

	decoder, err := goauthorization.NewDecoder(algorithm, audience, issuer, key)
	if err != nil {
		return nil, errors.Wrap(err, "authorization: failed to instantiate decoder")
	}

	return &Decoder{decoder}, nil
}
