package authorization

import (
	. "github.com/onsi/ginkgo"
	. "github.com/onsi/gomega"
)

var _ = Describe("Encoder", func() {
	It("errors when the key is not present at the given path", func() {
		bogusFilePath := "bogus"
		encoder, err := NewEncoder(bogusFilePath)

		Expect(err).To(HaveOccurred())
		Expect(encoder).To(BeNil())
	})

	It("errors when the key is invalid at the given path", func() {
		wrongFilePath := "development_ecc_public.key"
		encoder, err := NewEncoder(wrongFilePath)

		Expect(err).To(HaveOccurred())
		Expect(encoder).To(BeNil())
	})

	It("errors when the key is present and valid", func() {
		filePath := "development_ecc_private.key"
		encoder, err := NewEncoder(filePath)

		Expect(err).NotTo(HaveOccurred())
		Expect(encoder).NotTo(BeNil())
	})
})
