package awscredentials

import (
	"code.justin.tv/cb/roster/config"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/credentials/ec2rolecreds"
	"github.com/aws/aws-sdk-go/aws/session"
)

// New returns AWS Credentials object for the current env
// will be used to generate dynamo/sns clients
func New() (*credentials.Credentials, error) {
	if config.Environment == config.Development {
		return credentials.NewSharedCredentials("", "twitch-cb-aws"), nil
	}
	sess, err := session.NewSession(&aws.Config{
		Region: aws.String(config.Values.AWSRegion),
	})

	if err != nil {
		return nil, err
	}
	return ec2rolecreds.NewCredentials(sess), nil
}
